package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryVideoTaskInfo invokes the avatar.QueryVideoTaskInfo API synchronously
func (client *Client) QueryVideoTaskInfo(request *QueryVideoTaskInfoRequest) (response *QueryVideoTaskInfoResponse, err error) {
	response = CreateQueryVideoTaskInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryVideoTaskInfoWithChan invokes the avatar.QueryVideoTaskInfo API asynchronously
func (client *Client) QueryVideoTaskInfoWithChan(request *QueryVideoTaskInfoRequest) (<-chan *QueryVideoTaskInfoResponse, <-chan error) {
	responseChan := make(chan *QueryVideoTaskInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryVideoTaskInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryVideoTaskInfoWithCallback invokes the avatar.QueryVideoTaskInfo API asynchronously
func (client *Client) QueryVideoTaskInfoWithCallback(request *QueryVideoTaskInfoRequest, callback func(response *QueryVideoTaskInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryVideoTaskInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryVideoTaskInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryVideoTaskInfoRequest is the request struct for api QueryVideoTaskInfo
type QueryVideoTaskInfoRequest struct {
	*requests.RpcRequest
	App       QueryVideoTaskInfoApp `position:"Query" name:"App"  type:"Struct"`
	Title     string                `position:"Query" name:"Title"`
	Type      requests.Integer      `position:"Query" name:"Type"`
	OrderById string                `position:"Query" name:"OrderById"`
	PageNo    requests.Integer      `position:"Query" name:"PageNo"`
	TenantId  requests.Integer      `position:"Query" name:"TenantId"`
	PageSize  requests.Integer      `position:"Query" name:"PageSize"`
	TaskUuid  string                `position:"Query" name:"TaskUuid"`
	Status    requests.Integer      `position:"Query" name:"Status"`
}

// QueryVideoTaskInfoApp is a repeated param struct in QueryVideoTaskInfoRequest
type QueryVideoTaskInfoApp struct {
	AppId string `name:"AppId"`
}

// QueryVideoTaskInfoResponse is the response struct for api QueryVideoTaskInfo
type QueryVideoTaskInfoResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Success   bool                     `json:"Success" xml:"Success"`
	Code      string                   `json:"Code" xml:"Code"`
	Message   string                   `json:"Message" xml:"Message"`
	Data      DataInQueryVideoTaskInfo `json:"Data" xml:"Data"`
}

// CreateQueryVideoTaskInfoRequest creates a request to invoke QueryVideoTaskInfo API
func CreateQueryVideoTaskInfoRequest() (request *QueryVideoTaskInfoRequest) {
	request = &QueryVideoTaskInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "QueryVideoTaskInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryVideoTaskInfoResponse creates a response to parse from QueryVideoTaskInfo response
func CreateQueryVideoTaskInfoResponse() (response *QueryVideoTaskInfoResponse) {
	response = &QueryVideoTaskInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
