package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTimedResetOperateStatus invokes the avatar.QueryTimedResetOperateStatus API synchronously
func (client *Client) QueryTimedResetOperateStatus(request *QueryTimedResetOperateStatusRequest) (response *QueryTimedResetOperateStatusResponse, err error) {
	response = CreateQueryTimedResetOperateStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTimedResetOperateStatusWithChan invokes the avatar.QueryTimedResetOperateStatus API asynchronously
func (client *Client) QueryTimedResetOperateStatusWithChan(request *QueryTimedResetOperateStatusRequest) (<-chan *QueryTimedResetOperateStatusResponse, <-chan error) {
	responseChan := make(chan *QueryTimedResetOperateStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTimedResetOperateStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTimedResetOperateStatusWithCallback invokes the avatar.QueryTimedResetOperateStatus API asynchronously
func (client *Client) QueryTimedResetOperateStatusWithCallback(request *QueryTimedResetOperateStatusRequest, callback func(response *QueryTimedResetOperateStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTimedResetOperateStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryTimedResetOperateStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTimedResetOperateStatusRequest is the request struct for api QueryTimedResetOperateStatus
type QueryTimedResetOperateStatusRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	TenantId   requests.Integer `position:"Query" name:"TenantId"`
}

// QueryTimedResetOperateStatusResponse is the response struct for api QueryTimedResetOperateStatus
type QueryTimedResetOperateStatusResponse struct {
	*responses.BaseResponse
	RequestId string                             `json:"RequestId" xml:"RequestId"`
	Code      string                             `json:"Code" xml:"Code"`
	Message   string                             `json:"Message" xml:"Message"`
	Success   bool                               `json:"Success" xml:"Success"`
	Data      DataInQueryTimedResetOperateStatus `json:"Data" xml:"Data"`
}

// CreateQueryTimedResetOperateStatusRequest creates a request to invoke QueryTimedResetOperateStatus API
func CreateQueryTimedResetOperateStatusRequest() (request *QueryTimedResetOperateStatusRequest) {
	request = &QueryTimedResetOperateStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "QueryTimedResetOperateStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryTimedResetOperateStatusResponse creates a response to parse from QueryTimedResetOperateStatus response
func CreateQueryTimedResetOperateStatusResponse() (response *QueryTimedResetOperateStatusResponse) {
	response = &QueryTimedResetOperateStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
