package avatar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ClientUnbindDevice invokes the avatar.ClientUnbindDevice API synchronously
func (client *Client) ClientUnbindDevice(request *ClientUnbindDeviceRequest) (response *ClientUnbindDeviceResponse, err error) {
	response = CreateClientUnbindDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// ClientUnbindDeviceWithChan invokes the avatar.ClientUnbindDevice API asynchronously
func (client *Client) ClientUnbindDeviceWithChan(request *ClientUnbindDeviceRequest) (<-chan *ClientUnbindDeviceResponse, <-chan error) {
	responseChan := make(chan *ClientUnbindDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ClientUnbindDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ClientUnbindDeviceWithCallback invokes the avatar.ClientUnbindDevice API asynchronously
func (client *Client) ClientUnbindDeviceWithCallback(request *ClientUnbindDeviceRequest, callback func(response *ClientUnbindDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ClientUnbindDeviceResponse
		var err error
		defer close(result)
		response, err = client.ClientUnbindDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ClientUnbindDeviceRequest is the request struct for api ClientUnbindDevice
type ClientUnbindDeviceRequest struct {
	*requests.RpcRequest
	TenantId requests.Integer `position:"Query" name:"TenantId"`
	DeviceId string           `position:"Query" name:"DeviceId"`
}

// ClientUnbindDeviceResponse is the response struct for api ClientUnbindDevice
type ClientUnbindDeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateClientUnbindDeviceRequest creates a request to invoke ClientUnbindDevice API
func CreateClientUnbindDeviceRequest() (request *ClientUnbindDeviceRequest) {
	request = &ClientUnbindDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("avatar", "2022-01-30", "ClientUnbindDevice", "", "")
	request.Method = requests.POST
	return
}

// CreateClientUnbindDeviceResponse creates a response to parse from ClientUnbindDevice response
func CreateClientUnbindDeviceResponse() (response *ClientUnbindDeviceResponse) {
	response = &ClientUnbindDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
