package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UninstallManagedPrometheus invokes the arms.UninstallManagedPrometheus API synchronously
func (client *Client) UninstallManagedPrometheus(request *UninstallManagedPrometheusRequest) (response *UninstallManagedPrometheusResponse, err error) {
	response = CreateUninstallManagedPrometheusResponse()
	err = client.DoAction(request, response)
	return
}

// UninstallManagedPrometheusWithChan invokes the arms.UninstallManagedPrometheus API asynchronously
func (client *Client) UninstallManagedPrometheusWithChan(request *UninstallManagedPrometheusRequest) (<-chan *UninstallManagedPrometheusResponse, <-chan error) {
	responseChan := make(chan *UninstallManagedPrometheusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UninstallManagedPrometheus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UninstallManagedPrometheusWithCallback invokes the arms.UninstallManagedPrometheus API asynchronously
func (client *Client) UninstallManagedPrometheusWithCallback(request *UninstallManagedPrometheusRequest, callback func(response *UninstallManagedPrometheusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UninstallManagedPrometheusResponse
		var err error
		defer close(result)
		response, err = client.UninstallManagedPrometheus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UninstallManagedPrometheusRequest is the request struct for api UninstallManagedPrometheus
type UninstallManagedPrometheusRequest struct {
	*requests.RpcRequest
	ClusterId       string `position:"Query" name:"ClusterId"`
	ClusterType     string `position:"Query" name:"ClusterType"`
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	VpcId           string `position:"Query" name:"VpcId"`
}

// UninstallManagedPrometheusResponse is the response struct for api UninstallManagedPrometheus
type UninstallManagedPrometheusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Code      int    `json:"Code" xml:"Code"`
}

// CreateUninstallManagedPrometheusRequest creates a request to invoke UninstallManagedPrometheus API
func CreateUninstallManagedPrometheusRequest() (request *UninstallManagedPrometheusRequest) {
	request = &UninstallManagedPrometheusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "UninstallManagedPrometheus", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUninstallManagedPrometheusResponse creates a response to parse from UninstallManagedPrometheus response
func CreateUninstallManagedPrometheusResponse() (response *UninstallManagedPrometheusResponse) {
	response = &UninstallManagedPrometheusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
