package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateClusterSpecial invokes the amp.CreateClusterSpecial API synchronously
func (client *Client) CreateClusterSpecial(request *CreateClusterSpecialRequest) (response *CreateClusterSpecialResponse, err error) {
	response = CreateCreateClusterSpecialResponse()
	err = client.DoAction(request, response)
	return
}

// CreateClusterSpecialWithChan invokes the amp.CreateClusterSpecial API asynchronously
func (client *Client) CreateClusterSpecialWithChan(request *CreateClusterSpecialRequest) (<-chan *CreateClusterSpecialResponse, <-chan error) {
	responseChan := make(chan *CreateClusterSpecialResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateClusterSpecial(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateClusterSpecialWithCallback invokes the amp.CreateClusterSpecial API asynchronously
func (client *Client) CreateClusterSpecialWithCallback(request *CreateClusterSpecialRequest, callback func(response *CreateClusterSpecialResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateClusterSpecialResponse
		var err error
		defer close(result)
		response, err = client.CreateClusterSpecial(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateClusterSpecialRequest is the request struct for api CreateClusterSpecial
type CreateClusterSpecialRequest struct {
	*requests.RoaRequest
	YToken  string           `position:"Header" name:"Y-token"`
	XToken  string           `position:"Header" name:"X-token"`
	Filter1 string           `position:"Query" name:"Filter1"`
	Pid     requests.Integer `position:"Path" name:"Pid"`
	Filter2 requests.Boolean `position:"Query" name:"Filter2"`
	Cid     string           `position:"Path" name:"Cid"`
}

// CreateClusterSpecialResponse is the response struct for api CreateClusterSpecial
type CreateClusterSpecialResponse struct {
	*responses.BaseResponse
	ClusterId string `json:"cluster_id" xml:"cluster_id"`
	RequestId string `json:"request_id" xml:"request_id"`
	TaskId    string `json:"task_id" xml:"task_id"`
}

// CreateCreateClusterSpecialRequest creates a request to invoke CreateClusterSpecial API
func CreateCreateClusterSpecialRequest() (request *CreateClusterSpecialRequest) {
	request = &CreateClusterSpecialRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "CreateClusterSpecial", "/clusters/[Cid]/[Pid]/[aaa]/sdasd/[nnn]", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateClusterSpecialResponse creates a response to parse from CreateClusterSpecial response
func CreateCreateClusterSpecialResponse() (response *CreateClusterSpecialResponse) {
	response = &CreateClusterSpecialResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
