package alikafka

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReopenInstance invokes the alikafka.ReopenInstance API synchronously
func (client *Client) ReopenInstance(request *ReopenInstanceRequest) (response *ReopenInstanceResponse, err error) {
	response = CreateReopenInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ReopenInstanceWithChan invokes the alikafka.ReopenInstance API asynchronously
func (client *Client) ReopenInstanceWithChan(request *ReopenInstanceRequest) (<-chan *ReopenInstanceResponse, <-chan error) {
	responseChan := make(chan *ReopenInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReopenInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReopenInstanceWithCallback invokes the alikafka.ReopenInstance API asynchronously
func (client *Client) ReopenInstanceWithCallback(request *ReopenInstanceRequest, callback func(response *ReopenInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReopenInstanceResponse
		var err error
		defer close(result)
		response, err = client.ReopenInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReopenInstanceRequest is the request struct for api ReopenInstance
type ReopenInstanceRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ReopenInstanceResponse is the response struct for api ReopenInstance
type ReopenInstanceResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateReopenInstanceRequest creates a request to invoke ReopenInstance API
func CreateReopenInstanceRequest() (request *ReopenInstanceRequest) {
	request = &ReopenInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alikafka", "2019-09-16", "ReopenInstance", "alikafka", "openAPI")
	request.Method = requests.POST
	return
}

// CreateReopenInstanceResponse creates a response to parse from ReopenInstance response
func CreateReopenInstanceResponse() (response *ReopenInstanceResponse) {
	response = &ReopenInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
