package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDomainGroup invokes the alidns.UpdateDomainGroup API synchronously
func (client *Client) UpdateDomainGroup(request *UpdateDomainGroupRequest) (response *UpdateDomainGroupResponse, err error) {
	response = CreateUpdateDomainGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDomainGroupWithChan invokes the alidns.UpdateDomainGroup API asynchronously
func (client *Client) UpdateDomainGroupWithChan(request *UpdateDomainGroupRequest) (<-chan *UpdateDomainGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateDomainGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDomainGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDomainGroupWithCallback invokes the alidns.UpdateDomainGroup API asynchronously
func (client *Client) UpdateDomainGroupWithCallback(request *UpdateDomainGroupRequest, callback func(response *UpdateDomainGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDomainGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateDomainGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDomainGroupRequest is the request struct for api UpdateDomainGroup
type UpdateDomainGroupRequest struct {
	*requests.RpcRequest
	GroupId      string `position:"Query" name:"GroupId"`
	GroupName    string `position:"Query" name:"GroupName"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// UpdateDomainGroupResponse is the response struct for api UpdateDomainGroup
type UpdateDomainGroupResponse struct {
	*responses.BaseResponse
	GroupName string `json:"GroupName" xml:"GroupName"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	GroupId   string `json:"GroupId" xml:"GroupId"`
}

// CreateUpdateDomainGroupRequest creates a request to invoke UpdateDomainGroup API
func CreateUpdateDomainGroupRequest() (request *UpdateDomainGroupRequest) {
	request = &UpdateDomainGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "UpdateDomainGroup", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateDomainGroupResponse creates a response to parse from UpdateDomainGroup response
func CreateUpdateDomainGroupResponse() (response *UpdateDomainGroupResponse) {
	response = &UpdateDomainGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
