package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDnsGtmAccessStrategyAvailableConfig invokes the alidns.DescribeDnsGtmAccessStrategyAvailableConfig API synchronously
func (client *Client) DescribeDnsGtmAccessStrategyAvailableConfig(request *DescribeDnsGtmAccessStrategyAvailableConfigRequest) (response *DescribeDnsGtmAccessStrategyAvailableConfigResponse, err error) {
	response = CreateDescribeDnsGtmAccessStrategyAvailableConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDnsGtmAccessStrategyAvailableConfigWithChan invokes the alidns.DescribeDnsGtmAccessStrategyAvailableConfig API asynchronously
func (client *Client) DescribeDnsGtmAccessStrategyAvailableConfigWithChan(request *DescribeDnsGtmAccessStrategyAvailableConfigRequest) (<-chan *DescribeDnsGtmAccessStrategyAvailableConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeDnsGtmAccessStrategyAvailableConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDnsGtmAccessStrategyAvailableConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDnsGtmAccessStrategyAvailableConfigWithCallback invokes the alidns.DescribeDnsGtmAccessStrategyAvailableConfig API asynchronously
func (client *Client) DescribeDnsGtmAccessStrategyAvailableConfigWithCallback(request *DescribeDnsGtmAccessStrategyAvailableConfigRequest, callback func(response *DescribeDnsGtmAccessStrategyAvailableConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDnsGtmAccessStrategyAvailableConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeDnsGtmAccessStrategyAvailableConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDnsGtmAccessStrategyAvailableConfigRequest is the request struct for api DescribeDnsGtmAccessStrategyAvailableConfig
type DescribeDnsGtmAccessStrategyAvailableConfigRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	StrategyMode string `position:"Query" name:"StrategyMode"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeDnsGtmAccessStrategyAvailableConfigResponse is the response struct for api DescribeDnsGtmAccessStrategyAvailableConfig
type DescribeDnsGtmAccessStrategyAvailableConfigResponse struct {
	*responses.BaseResponse
	RequestId             string                                             `json:"RequestId" xml:"RequestId"`
	SuggestSetDefaultLine bool                                               `json:"SuggestSetDefaultLine" xml:"SuggestSetDefaultLine"`
	SelectedDomainLines   SelectedDomainLines                                `json:"SelectedDomainLines" xml:"SelectedDomainLines"`
	SelectedIpv4Lines     SelectedIpv4Lines                                  `json:"SelectedIpv4Lines" xml:"SelectedIpv4Lines"`
	SelectedIpv6Lines     SelectedIpv6Lines                                  `json:"SelectedIpv6Lines" xml:"SelectedIpv6Lines"`
	DomainAddrPools       DomainAddrPools                                    `json:"DomainAddrPools" xml:"DomainAddrPools"`
	Ipv4AddrPools         Ipv4AddrPools                                      `json:"Ipv4AddrPools" xml:"Ipv4AddrPools"`
	Ipv6AddrPools         Ipv6AddrPools                                      `json:"Ipv6AddrPools" xml:"Ipv6AddrPools"`
	Lines                 LinesInDescribeDnsGtmAccessStrategyAvailableConfig `json:"Lines" xml:"Lines"`
}

// CreateDescribeDnsGtmAccessStrategyAvailableConfigRequest creates a request to invoke DescribeDnsGtmAccessStrategyAvailableConfig API
func CreateDescribeDnsGtmAccessStrategyAvailableConfigRequest() (request *DescribeDnsGtmAccessStrategyAvailableConfigRequest) {
	request = &DescribeDnsGtmAccessStrategyAvailableConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDnsGtmAccessStrategyAvailableConfig", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDnsGtmAccessStrategyAvailableConfigResponse creates a response to parse from DescribeDnsGtmAccessStrategyAvailableConfig response
func CreateDescribeDnsGtmAccessStrategyAvailableConfigResponse() (response *DescribeDnsGtmAccessStrategyAvailableConfigResponse) {
	response = &DescribeDnsGtmAccessStrategyAvailableConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
