package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDnsGtmAddressPool invokes the alidns.DeleteDnsGtmAddressPool API synchronously
func (client *Client) DeleteDnsGtmAddressPool(request *DeleteDnsGtmAddressPoolRequest) (response *DeleteDnsGtmAddressPoolResponse, err error) {
	response = CreateDeleteDnsGtmAddressPoolResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDnsGtmAddressPoolWithChan invokes the alidns.DeleteDnsGtmAddressPool API asynchronously
func (client *Client) DeleteDnsGtmAddressPoolWithChan(request *DeleteDnsGtmAddressPoolRequest) (<-chan *DeleteDnsGtmAddressPoolResponse, <-chan error) {
	responseChan := make(chan *DeleteDnsGtmAddressPoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDnsGtmAddressPool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDnsGtmAddressPoolWithCallback invokes the alidns.DeleteDnsGtmAddressPool API asynchronously
func (client *Client) DeleteDnsGtmAddressPoolWithCallback(request *DeleteDnsGtmAddressPoolRequest, callback func(response *DeleteDnsGtmAddressPoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDnsGtmAddressPoolResponse
		var err error
		defer close(result)
		response, err = client.DeleteDnsGtmAddressPool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDnsGtmAddressPoolRequest is the request struct for api DeleteDnsGtmAddressPool
type DeleteDnsGtmAddressPoolRequest struct {
	*requests.RpcRequest
	AddrPoolId   string `position:"Query" name:"AddrPoolId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DeleteDnsGtmAddressPoolResponse is the response struct for api DeleteDnsGtmAddressPool
type DeleteDnsGtmAddressPoolResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDnsGtmAddressPoolRequest creates a request to invoke DeleteDnsGtmAddressPool API
func CreateDeleteDnsGtmAddressPoolRequest() (request *DeleteDnsGtmAddressPoolRequest) {
	request = &DeleteDnsGtmAddressPoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DeleteDnsGtmAddressPool", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDnsGtmAddressPoolResponse creates a response to parse from DeleteDnsGtmAddressPool response
func CreateDeleteDnsGtmAddressPoolResponse() (response *DeleteDnsGtmAddressPoolResponse) {
	response = &DeleteDnsGtmAddressPoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
