package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateHealthCheckTemplateAttribute invokes the alb.UpdateHealthCheckTemplateAttribute API synchronously
func (client *Client) UpdateHealthCheckTemplateAttribute(request *UpdateHealthCheckTemplateAttributeRequest) (response *UpdateHealthCheckTemplateAttributeResponse, err error) {
	response = CreateUpdateHealthCheckTemplateAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateHealthCheckTemplateAttributeWithChan invokes the alb.UpdateHealthCheckTemplateAttribute API asynchronously
func (client *Client) UpdateHealthCheckTemplateAttributeWithChan(request *UpdateHealthCheckTemplateAttributeRequest) (<-chan *UpdateHealthCheckTemplateAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateHealthCheckTemplateAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateHealthCheckTemplateAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateHealthCheckTemplateAttributeWithCallback invokes the alb.UpdateHealthCheckTemplateAttribute API asynchronously
func (client *Client) UpdateHealthCheckTemplateAttributeWithCallback(request *UpdateHealthCheckTemplateAttributeRequest, callback func(response *UpdateHealthCheckTemplateAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateHealthCheckTemplateAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateHealthCheckTemplateAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateHealthCheckTemplateAttributeRequest is the request struct for api UpdateHealthCheckTemplateAttribute
type UpdateHealthCheckTemplateAttributeRequest struct {
	*requests.RpcRequest
	HealthCheckTimeout             requests.Integer `position:"Query" name:"HealthCheckTimeout"`
	ClientToken                    string           `position:"Query" name:"ClientToken"`
	HealthCheckProtocol            string           `position:"Query" name:"HealthCheckProtocol"`
	UnhealthyThreshold             requests.Integer `position:"Query" name:"UnhealthyThreshold"`
	HealthyThreshold               requests.Integer `position:"Query" name:"HealthyThreshold"`
	HealthCheckTcpFastCloseEnabled requests.Boolean `position:"Query" name:"HealthCheckTcpFastCloseEnabled"`
	HealthCheckPath                string           `position:"Query" name:"HealthCheckPath"`
	HealthCheckCodes               *[]string        `position:"Query" name:"HealthCheckCodes"  type:"Repeated"`
	DryRun                         requests.Boolean `position:"Query" name:"DryRun"`
	HealthCheckMethod              string           `position:"Query" name:"HealthCheckMethod"`
	HealthCheckHost                string           `position:"Query" name:"HealthCheckHost"`
	HealthCheckInterval            requests.Integer `position:"Query" name:"HealthCheckInterval"`
	HealthCheckTemplateName        string           `position:"Query" name:"HealthCheckTemplateName"`
	HealthCheckHttpCodes           *[]string        `position:"Query" name:"HealthCheckHttpCodes"  type:"Repeated"`
	HealthCheckTemplateId          string           `position:"Query" name:"HealthCheckTemplateId"`
	HealthCheckHttpVersion         string           `position:"Query" name:"HealthCheckHttpVersion"`
	HealthCheckConnectPort         requests.Integer `position:"Query" name:"HealthCheckConnectPort"`
}

// UpdateHealthCheckTemplateAttributeResponse is the response struct for api UpdateHealthCheckTemplateAttribute
type UpdateHealthCheckTemplateAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateHealthCheckTemplateAttributeRequest creates a request to invoke UpdateHealthCheckTemplateAttribute API
func CreateUpdateHealthCheckTemplateAttributeRequest() (request *UpdateHealthCheckTemplateAttributeRequest) {
	request = &UpdateHealthCheckTemplateAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "UpdateHealthCheckTemplateAttribute", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateHealthCheckTemplateAttributeResponse creates a response to parse from UpdateHealthCheckTemplateAttribute response
func CreateUpdateHealthCheckTemplateAttributeResponse() (response *UpdateHealthCheckTemplateAttributeResponse) {
	response = &UpdateHealthCheckTemplateAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
