package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateServerGroup invokes the alb.CreateServerGroup API synchronously
func (client *Client) CreateServerGroup(request *CreateServerGroupRequest) (response *CreateServerGroupResponse, err error) {
	response = CreateCreateServerGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateServerGroupWithChan invokes the alb.CreateServerGroup API asynchronously
func (client *Client) CreateServerGroupWithChan(request *CreateServerGroupRequest) (<-chan *CreateServerGroupResponse, <-chan error) {
	responseChan := make(chan *CreateServerGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateServerGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateServerGroupWithCallback invokes the alb.CreateServerGroup API asynchronously
func (client *Client) CreateServerGroupWithCallback(request *CreateServerGroupRequest, callback func(response *CreateServerGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateServerGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateServerGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateServerGroupRequest is the request struct for api CreateServerGroup
type CreateServerGroupRequest struct {
	*requests.RpcRequest
	CrossZoneEnabled         requests.Boolean                       `position:"Query" name:"CrossZoneEnabled"`
	ServerGroupName          string                                 `position:"Query" name:"ServerGroupName"`
	ClientToken              string                                 `position:"Query" name:"ClientToken"`
	HealthCheckConfig        CreateServerGroupHealthCheckConfig     `position:"Query" name:"HealthCheckConfig"  type:"Struct"`
	SlowStartConfig          CreateServerGroupSlowStartConfig       `position:"Query" name:"SlowStartConfig"  type:"Struct"`
	Scheduler                string                                 `position:"Query" name:"Scheduler"`
	ResourceGroupId          string                                 `position:"Query" name:"ResourceGroupId"`
	Protocol                 string                                 `position:"Query" name:"Protocol"`
	UpstreamKeepaliveEnabled requests.Boolean                       `position:"Query" name:"UpstreamKeepaliveEnabled"`
	ServiceName              string                                 `position:"Query" name:"ServiceName"`
	Tag                      *[]CreateServerGroupTag                `position:"Query" name:"Tag"  type:"Repeated"`
	StickySessionConfig      CreateServerGroupStickySessionConfig   `position:"Query" name:"StickySessionConfig"  type:"Struct"`
	DryRun                   requests.Boolean                       `position:"Query" name:"DryRun"`
	Ipv6Enabled              requests.Boolean                       `position:"Query" name:"Ipv6Enabled"`
	ConnectionDrainConfig    CreateServerGroupConnectionDrainConfig `position:"Query" name:"ConnectionDrainConfig"  type:"Struct"`
	ServerGroupType          string                                 `position:"Query" name:"ServerGroupType"`
	VpcId                    string                                 `position:"Query" name:"VpcId"`
	UchConfig                CreateServerGroupUchConfig             `position:"Query" name:"UchConfig"  type:"Struct"`
}

// CreateServerGroupTag is a repeated param struct in CreateServerGroupRequest
type CreateServerGroupTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateServerGroupHealthCheckConfig is a repeated param struct in CreateServerGroupRequest
type CreateServerGroupHealthCheckConfig struct {
	HealthCheckCodes               *[]string `name:"HealthCheckCodes" type:"Repeated"`
	HealthCheckEnabled             string    `name:"HealthCheckEnabled"`
	HealthCheckTimeout             string    `name:"HealthCheckTimeout"`
	HealthCheckMethod              string    `name:"HealthCheckMethod"`
	HealthCheckHost                string    `name:"HealthCheckHost"`
	HealthCheckProtocol            string    `name:"HealthCheckProtocol"`
	UnhealthyThreshold             string    `name:"UnhealthyThreshold"`
	HealthyThreshold               string    `name:"HealthyThreshold"`
	HealthCheckTcpFastCloseEnabled string    `name:"HealthCheckTcpFastCloseEnabled"`
	HealthCheckPath                string    `name:"HealthCheckPath"`
	HealthCheckInterval            string    `name:"HealthCheckInterval"`
	HealthCheckHttpCodes           *[]string `name:"HealthCheckHttpCodes" type:"Repeated"`
	HealthCheckHttpVersion         string    `name:"HealthCheckHttpVersion"`
	HealthCheckConnectPort         string    `name:"HealthCheckConnectPort"`
}

// CreateServerGroupSlowStartConfig is a repeated param struct in CreateServerGroupRequest
type CreateServerGroupSlowStartConfig struct {
	SlowStartDuration string `name:"SlowStartDuration"`
	SlowStartEnabled  string `name:"SlowStartEnabled"`
}

// CreateServerGroupStickySessionConfig is a repeated param struct in CreateServerGroupRequest
type CreateServerGroupStickySessionConfig struct {
	StickySessionEnabled string `name:"StickySessionEnabled"`
	Cookie               string `name:"Cookie"`
	CookieTimeout        string `name:"CookieTimeout"`
	StickySessionType    string `name:"StickySessionType"`
}

// CreateServerGroupConnectionDrainConfig is a repeated param struct in CreateServerGroupRequest
type CreateServerGroupConnectionDrainConfig struct {
	ConnectionDrainEnabled string `name:"ConnectionDrainEnabled"`
	ConnectionDrainTimeout string `name:"ConnectionDrainTimeout"`
}

// CreateServerGroupUchConfig is a repeated param struct in CreateServerGroupRequest
type CreateServerGroupUchConfig struct {
	Type  string `name:"Type"`
	Value string `name:"Value"`
}

// CreateServerGroupResponse is the response struct for api CreateServerGroup
type CreateServerGroupResponse struct {
	*responses.BaseResponse
	JobId         string `json:"JobId" xml:"JobId"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ServerGroupId string `json:"ServerGroupId" xml:"ServerGroupId"`
}

// CreateCreateServerGroupRequest creates a request to invoke CreateServerGroup API
func CreateCreateServerGroupRequest() (request *CreateServerGroupRequest) {
	request = &CreateServerGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "CreateServerGroup", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateServerGroupResponse creates a response to parse from CreateServerGroup response
func CreateCreateServerGroupResponse() (response *CreateServerGroupResponse) {
	response = &CreateServerGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
