package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyItems invokes the airec.ModifyItems API synchronously
func (client *Client) ModifyItems(request *ModifyItemsRequest) (response *ModifyItemsResponse, err error) {
	response = CreateModifyItemsResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyItemsWithChan invokes the airec.ModifyItems API asynchronously
func (client *Client) ModifyItemsWithChan(request *ModifyItemsRequest) (<-chan *ModifyItemsResponse, <-chan error) {
	responseChan := make(chan *ModifyItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyItemsWithCallback invokes the airec.ModifyItems API asynchronously
func (client *Client) ModifyItemsWithCallback(request *ModifyItemsRequest, callback func(response *ModifyItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyItemsResponse
		var err error
		defer close(result)
		response, err = client.ModifyItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyItemsRequest is the request struct for api ModifyItems
type ModifyItemsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
}

// ModifyItemsResponse is the response struct for api ModifyItems
type ModifyItemsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    bool   `json:"result" xml:"result"`
}

// CreateModifyItemsRequest creates a request to invoke ModifyItems API
func CreateModifyItemsRequest() (request *ModifyItemsRequest) {
	request = &ModifyItemsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "ModifyItems", "/v2/openapi/instances/[instanceId]/items", "airec", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyItemsResponse creates a response to parse from ModifyItems response
func CreateModifyItemsResponse() (response *ModifyItemsResponse) {
	response = &ModifyItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
