package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSystemRule invokes the ahas_openapi.DeleteSystemRule API synchronously
func (client *Client) DeleteSystemRule(request *DeleteSystemRuleRequest) (response *DeleteSystemRuleResponse, err error) {
	response = CreateDeleteSystemRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSystemRuleWithChan invokes the ahas_openapi.DeleteSystemRule API asynchronously
func (client *Client) DeleteSystemRuleWithChan(request *DeleteSystemRuleRequest) (<-chan *DeleteSystemRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteSystemRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSystemRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSystemRuleWithCallback invokes the ahas_openapi.DeleteSystemRule API asynchronously
func (client *Client) DeleteSystemRuleWithCallback(request *DeleteSystemRuleRequest, callback func(response *DeleteSystemRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSystemRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteSystemRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSystemRuleRequest is the request struct for api DeleteSystemRule
type DeleteSystemRuleRequest struct {
	*requests.RpcRequest
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	RuleId       requests.Integer `position:"Query" name:"RuleId"`
}

// DeleteSystemRuleResponse is the response struct for api DeleteSystemRule
type DeleteSystemRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDeleteSystemRuleRequest creates a request to invoke DeleteSystemRule API
func CreateDeleteSystemRuleRequest() (request *DeleteSystemRuleRequest) {
	request = &DeleteSystemRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "DeleteSystemRule", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteSystemRuleResponse creates a response to parse from DeleteSystemRule response
func CreateDeleteSystemRuleResponse() (response *DeleteSystemRuleResponse) {
	response = &DeleteSystemRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
