package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEIURange invokes the adb.DescribeEIURange API synchronously
func (client *Client) DescribeEIURange(request *DescribeEIURangeRequest) (response *DescribeEIURangeResponse, err error) {
	response = CreateDescribeEIURangeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEIURangeWithChan invokes the adb.DescribeEIURange API asynchronously
func (client *Client) DescribeEIURangeWithChan(request *DescribeEIURangeRequest) (<-chan *DescribeEIURangeResponse, <-chan error) {
	responseChan := make(chan *DescribeEIURangeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEIURange(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEIURangeWithCallback invokes the adb.DescribeEIURange API asynchronously
func (client *Client) DescribeEIURangeWithCallback(request *DescribeEIURangeRequest, callback func(response *DescribeEIURangeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEIURangeResponse
		var err error
		defer close(result)
		response, err = client.DescribeEIURange(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEIURangeRequest is the request struct for api DescribeEIURange
type DescribeEIURangeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	DBClusterVersion     string           `position:"Query" name:"DBClusterVersion"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
	ComputeResource      string           `position:"Query" name:"ComputeResource"`
	Operation            string           `position:"Query" name:"Operation"`
}

// DescribeEIURangeResponse is the response struct for api DescribeEIURange
type DescribeEIURangeResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	EIUInfo   EIUInfo `json:"EIUInfo" xml:"EIUInfo"`
}

// CreateDescribeEIURangeRequest creates a request to invoke DescribeEIURange API
func CreateDescribeEIURangeRequest() (request *DescribeEIURangeRequest) {
	request = &DescribeEIURangeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeEIURange", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEIURangeResponse creates a response to parse from DescribeEIURange response
func CreateDescribeEIURangeResponse() (response *DescribeEIURangeResponse) {
	response = &DescribeEIURangeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
