package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RestartAppEnv invokes the webplus.RestartAppEnv API synchronously
// api document: https://help.aliyun.com/api/webplus/restartappenv.html
func (client *Client) RestartAppEnv(request *RestartAppEnvRequest) (response *RestartAppEnvResponse, err error) {
	response = CreateRestartAppEnvResponse()
	err = client.DoAction(request, response)
	return
}

// RestartAppEnvWithChan invokes the webplus.RestartAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/restartappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RestartAppEnvWithChan(request *RestartAppEnvRequest) (<-chan *RestartAppEnvResponse, <-chan error) {
	responseChan := make(chan *RestartAppEnvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RestartAppEnv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RestartAppEnvWithCallback invokes the webplus.RestartAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/restartappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RestartAppEnvWithCallback(request *RestartAppEnvRequest, callback func(response *RestartAppEnvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RestartAppEnvResponse
		var err error
		defer close(result)
		response, err = client.RestartAppEnv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RestartAppEnvRequest is the request struct for api RestartAppEnv
type RestartAppEnvRequest struct {
	*requests.RoaRequest
	EnvId string `position:"Body" name:"EnvId"`
}

// RestartAppEnvResponse is the response struct for api RestartAppEnv
type RestartAppEnvResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Code      string    `json:"Code" xml:"Code"`
	Message   string    `json:"Message" xml:"Message"`
	EnvChange EnvChange `json:"EnvChange" xml:"EnvChange"`
}

// CreateRestartAppEnvRequest creates a request to invoke RestartAppEnv API
func CreateRestartAppEnvRequest() (request *RestartAppEnvRequest) {
	request = &RestartAppEnvRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "RestartAppEnv", "/pop/v1/wam/appEnv/restart", "", "")
	request.Method = requests.POST
	return
}

// CreateRestartAppEnvResponse creates a response to parse from RestartAppEnv response
func CreateRestartAppEnvResponse() (response *RestartAppEnvResponse) {
	response = &RestartAppEnvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
