package vs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVsCertificateDetail invokes the vs.DescribeVsCertificateDetail API synchronously
func (client *Client) DescribeVsCertificateDetail(request *DescribeVsCertificateDetailRequest) (response *DescribeVsCertificateDetailResponse, err error) {
	response = CreateDescribeVsCertificateDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVsCertificateDetailWithChan invokes the vs.DescribeVsCertificateDetail API asynchronously
func (client *Client) DescribeVsCertificateDetailWithChan(request *DescribeVsCertificateDetailRequest) (<-chan *DescribeVsCertificateDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeVsCertificateDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVsCertificateDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVsCertificateDetailWithCallback invokes the vs.DescribeVsCertificateDetail API asynchronously
func (client *Client) DescribeVsCertificateDetailWithCallback(request *DescribeVsCertificateDetailRequest, callback func(response *DescribeVsCertificateDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVsCertificateDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeVsCertificateDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVsCertificateDetailRequest is the request struct for api DescribeVsCertificateDetail
type DescribeVsCertificateDetailRequest struct {
	*requests.RpcRequest
	ShowLog  string           `position:"Query" name:"ShowLog"`
	CertName string           `position:"Query" name:"CertName"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVsCertificateDetailResponse is the response struct for api DescribeVsCertificateDetail
type DescribeVsCertificateDetailResponse struct {
	*responses.BaseResponse
	CertName  string `json:"CertName" xml:"CertName"`
	Key       string `json:"Key" xml:"Key"`
	Cert      string `json:"Cert" xml:"Cert"`
	CertId    int64  `json:"CertId" xml:"CertId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeVsCertificateDetailRequest creates a request to invoke DescribeVsCertificateDetail API
func CreateDescribeVsCertificateDetailRequest() (request *DescribeVsCertificateDetailRequest) {
	request = &DescribeVsCertificateDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vs", "2018-12-12", "DescribeVsCertificateDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeVsCertificateDetailResponse creates a response to parse from DescribeVsCertificateDetail response
func CreateDescribeVsCertificateDetailResponse() (response *DescribeVsCertificateDetailResponse) {
	response = &DescribeVsCertificateDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
