package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyIpv6GatewayAttribute invokes the vpc.ModifyIpv6GatewayAttribute API synchronously
func (client *Client) ModifyIpv6GatewayAttribute(request *ModifyIpv6GatewayAttributeRequest) (response *ModifyIpv6GatewayAttributeResponse, err error) {
	response = CreateModifyIpv6GatewayAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyIpv6GatewayAttributeWithChan invokes the vpc.ModifyIpv6GatewayAttribute API asynchronously
func (client *Client) ModifyIpv6GatewayAttributeWithChan(request *ModifyIpv6GatewayAttributeRequest) (<-chan *ModifyIpv6GatewayAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyIpv6GatewayAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyIpv6GatewayAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyIpv6GatewayAttributeWithCallback invokes the vpc.ModifyIpv6GatewayAttribute API asynchronously
func (client *Client) ModifyIpv6GatewayAttributeWithCallback(request *ModifyIpv6GatewayAttributeRequest, callback func(response *ModifyIpv6GatewayAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyIpv6GatewayAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyIpv6GatewayAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyIpv6GatewayAttributeRequest is the request struct for api ModifyIpv6GatewayAttribute
type ModifyIpv6GatewayAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Description          string           `position:"Query" name:"Description"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Ipv6GatewayId        string           `position:"Query" name:"Ipv6GatewayId"`
	Name                 string           `position:"Query" name:"Name"`
}

// ModifyIpv6GatewayAttributeResponse is the response struct for api ModifyIpv6GatewayAttribute
type ModifyIpv6GatewayAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyIpv6GatewayAttributeRequest creates a request to invoke ModifyIpv6GatewayAttribute API
func CreateModifyIpv6GatewayAttributeRequest() (request *ModifyIpv6GatewayAttributeRequest) {
	request = &ModifyIpv6GatewayAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyIpv6GatewayAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyIpv6GatewayAttributeResponse creates a response to parse from ModifyIpv6GatewayAttribute response
func CreateModifyIpv6GatewayAttributeResponse() (response *ModifyIpv6GatewayAttributeResponse) {
	response = &ModifyIpv6GatewayAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
