package videoenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddFaceVideoTemplate invokes the videoenhan.AddFaceVideoTemplate API synchronously
func (client *Client) AddFaceVideoTemplate(request *AddFaceVideoTemplateRequest) (response *AddFaceVideoTemplateResponse, err error) {
	response = CreateAddFaceVideoTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// AddFaceVideoTemplateWithChan invokes the videoenhan.AddFaceVideoTemplate API asynchronously
func (client *Client) AddFaceVideoTemplateWithChan(request *AddFaceVideoTemplateRequest) (<-chan *AddFaceVideoTemplateResponse, <-chan error) {
	responseChan := make(chan *AddFaceVideoTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddFaceVideoTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddFaceVideoTemplateWithCallback invokes the videoenhan.AddFaceVideoTemplate API asynchronously
func (client *Client) AddFaceVideoTemplateWithCallback(request *AddFaceVideoTemplateRequest, callback func(response *AddFaceVideoTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddFaceVideoTemplateResponse
		var err error
		defer close(result)
		response, err = client.AddFaceVideoTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddFaceVideoTemplateRequest is the request struct for api AddFaceVideoTemplate
type AddFaceVideoTemplateRequest struct {
	*requests.RpcRequest
	UserId      string           `position:"Body" name:"UserId"`
	VideoScene  string           `position:"Body" name:"VideoScene"`
	ReturnTrans requests.Boolean `position:"Body" name:"ReturnTrans"`
	Async       requests.Boolean `position:"Body" name:"Async"`
	VideoURL    string           `position:"Body" name:"VideoURL"`
}

// AddFaceVideoTemplateResponse is the response struct for api AddFaceVideoTemplate
type AddFaceVideoTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Date      Date   `json:"Date" xml:"Date"`
}

// CreateAddFaceVideoTemplateRequest creates a request to invoke AddFaceVideoTemplate API
func CreateAddFaceVideoTemplateRequest() (request *AddFaceVideoTemplateRequest) {
	request = &AddFaceVideoTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("videoenhan", "2020-03-20", "AddFaceVideoTemplate", "videoenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddFaceVideoTemplateResponse creates a response to parse from AddFaceVideoTemplate response
func CreateAddFaceVideoTemplateResponse() (response *AddFaceVideoTemplateResponse) {
	response = &AddFaceVideoTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
