package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListLabelsets invokes the viapi_regen.ListLabelsets API synchronously
func (client *Client) ListLabelsets(request *ListLabelsetsRequest) (response *ListLabelsetsResponse, err error) {
	response = CreateListLabelsetsResponse()
	err = client.DoAction(request, response)
	return
}

// ListLabelsetsWithChan invokes the viapi_regen.ListLabelsets API asynchronously
func (client *Client) ListLabelsetsWithChan(request *ListLabelsetsRequest) (<-chan *ListLabelsetsResponse, <-chan error) {
	responseChan := make(chan *ListLabelsetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListLabelsets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListLabelsetsWithCallback invokes the viapi_regen.ListLabelsets API asynchronously
func (client *Client) ListLabelsetsWithCallback(request *ListLabelsetsRequest, callback func(response *ListLabelsetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListLabelsetsResponse
		var err error
		defer close(result)
		response, err = client.ListLabelsets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListLabelsetsRequest is the request struct for api ListLabelsets
type ListLabelsetsRequest struct {
	*requests.RpcRequest
	PageSize    requests.Integer `position:"Body" name:"PageSize"`
	CurrentPage requests.Integer `position:"Body" name:"CurrentPage"`
	DatasetId   requests.Integer `position:"Body" name:"DatasetId"`
	Status      string           `position:"Body" name:"Status"`
}

// ListLabelsetsResponse is the response struct for api ListLabelsets
type ListLabelsetsResponse struct {
	*responses.BaseResponse
	Message   string              `json:"Message" xml:"Message"`
	RequestId string              `json:"RequestId" xml:"RequestId"`
	Code      string              `json:"Code" xml:"Code"`
	Data      DataInListLabelsets `json:"Data" xml:"Data"`
}

// CreateListLabelsetsRequest creates a request to invoke ListLabelsets API
func CreateListLabelsetsRequest() (request *ListLabelsetsRequest) {
	request = &ListLabelsetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "ListLabelsets", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListLabelsetsResponse creates a response to parse from ListLabelsets response
func CreateListLabelsetsResponse() (response *ListLabelsetsResponse) {
	response = &ListLabelsetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
