package viapi_regen

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTagTask invokes the viapi_regen.CreateTagTask API synchronously
func (client *Client) CreateTagTask(request *CreateTagTaskRequest) (response *CreateTagTaskResponse, err error) {
	response = CreateCreateTagTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTagTaskWithChan invokes the viapi_regen.CreateTagTask API asynchronously
func (client *Client) CreateTagTaskWithChan(request *CreateTagTaskRequest) (<-chan *CreateTagTaskResponse, <-chan error) {
	responseChan := make(chan *CreateTagTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTagTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTagTaskWithCallback invokes the viapi_regen.CreateTagTask API asynchronously
func (client *Client) CreateTagTaskWithCallback(request *CreateTagTaskRequest, callback func(response *CreateTagTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTagTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateTagTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTagTaskRequest is the request struct for api CreateTagTask
type CreateTagTaskRequest struct {
	*requests.RpcRequest
	LabelsetId requests.Integer `position:"Body" name:"LabelsetId"`
}

// CreateTagTaskResponse is the response struct for api CreateTagTask
type CreateTagTaskResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateTagTaskRequest creates a request to invoke CreateTagTask API
func CreateCreateTagTaskRequest() (request *CreateTagTaskRequest) {
	request = &CreateTagTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("viapi-regen", "2021-11-19", "CreateTagTask", "selflearning", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTagTaskResponse creates a response to parse from CreateTagTask response
func CreateCreateTagTaskResponse() (response *CreateTagTaskResponse) {
	response = &CreateTagTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
