package uis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateUisNetworkInterface invokes the uis.CreateUisNetworkInterface API synchronously
// api document: https://help.aliyun.com/api/uis/createuisnetworkinterface.html
func (client *Client) CreateUisNetworkInterface(request *CreateUisNetworkInterfaceRequest) (response *CreateUisNetworkInterfaceResponse, err error) {
	response = CreateCreateUisNetworkInterfaceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateUisNetworkInterfaceWithChan invokes the uis.CreateUisNetworkInterface API asynchronously
// api document: https://help.aliyun.com/api/uis/createuisnetworkinterface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUisNetworkInterfaceWithChan(request *CreateUisNetworkInterfaceRequest) (<-chan *CreateUisNetworkInterfaceResponse, <-chan error) {
	responseChan := make(chan *CreateUisNetworkInterfaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateUisNetworkInterface(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateUisNetworkInterfaceWithCallback invokes the uis.CreateUisNetworkInterface API asynchronously
// api document: https://help.aliyun.com/api/uis/createuisnetworkinterface.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateUisNetworkInterfaceWithCallback(request *CreateUisNetworkInterfaceRequest, callback func(response *CreateUisNetworkInterfaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateUisNetworkInterfaceResponse
		var err error
		defer close(result)
		response, err = client.CreateUisNetworkInterface(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateUisNetworkInterfaceRequest is the request struct for api CreateUisNetworkInterface
type CreateUisNetworkInterfaceRequest struct {
	*requests.RpcRequest
	VswitchId            string           `position:"Query" name:"VswitchId"`
	IpAddress            string           `position:"Query" name:"IpAddress"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	UisNodeId            string           `position:"Query" name:"UisNodeId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	SecurityGroupId      string           `position:"Query" name:"SecurityGroupId"`
	Name                 string           `position:"Query" name:"Name"`
	Description          string           `position:"Query" name:"Description"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CreateUisNetworkInterfaceResponse is the response struct for api CreateUisNetworkInterface
type CreateUisNetworkInterfaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	UisEniId  string `json:"UisEniId" xml:"UisEniId"`
}

// CreateCreateUisNetworkInterfaceRequest creates a request to invoke CreateUisNetworkInterface API
func CreateCreateUisNetworkInterfaceRequest() (request *CreateUisNetworkInterfaceRequest) {
	request = &CreateUisNetworkInterfaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Uis", "2018-08-21", "CreateUisNetworkInterface", "uis", "openAPI")
	return
}

// CreateCreateUisNetworkInterfaceResponse creates a response to parse from CreateUisNetworkInterface response
func CreateCreateUisNetworkInterfaceResponse() (response *CreateUisNetworkInterfaceResponse) {
	response = &CreateUisNetworkInterfaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
