package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTreeData invokes the sophonsoar.QueryTreeData API synchronously
func (client *Client) QueryTreeData(request *QueryTreeDataRequest) (response *QueryTreeDataResponse, err error) {
	response = CreateQueryTreeDataResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTreeDataWithChan invokes the sophonsoar.QueryTreeData API asynchronously
func (client *Client) QueryTreeDataWithChan(request *QueryTreeDataRequest) (<-chan *QueryTreeDataResponse, <-chan error) {
	responseChan := make(chan *QueryTreeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTreeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTreeDataWithCallback invokes the sophonsoar.QueryTreeData API asynchronously
func (client *Client) QueryTreeDataWithCallback(request *QueryTreeDataRequest, callback func(response *QueryTreeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTreeDataResponse
		var err error
		defer close(result)
		response, err = client.QueryTreeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTreeDataRequest is the request struct for api QueryTreeData
type QueryTreeDataRequest struct {
	*requests.RpcRequest
	RoleFor  string `position:"Query" name:"RoleFor"`
	RoleType string `position:"Query" name:"RoleType"`
	Lang     string `position:"Query" name:"Lang"`
}

// QueryTreeDataResponse is the response struct for api QueryTreeData
type QueryTreeDataResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Playbooks string `json:"Playbooks" xml:"Playbooks"`
}

// CreateQueryTreeDataRequest creates a request to invoke QueryTreeData API
func CreateQueryTreeDataRequest() (request *QueryTreeDataRequest) {
	request = &QueryTreeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "QueryTreeData", "", "")
	request.Method = requests.GET
	return
}

// CreateQueryTreeDataResponse creates a response to parse from QueryTreeData response
func CreateQueryTreeDataResponse() (response *QueryTreeDataResponse) {
	response = &QueryTreeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
