package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDnatEntry invokes the smartag.DeleteDnatEntry API synchronously
func (client *Client) DeleteDnatEntry(request *DeleteDnatEntryRequest) (response *DeleteDnatEntryResponse, err error) {
	response = CreateDeleteDnatEntryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDnatEntryWithChan invokes the smartag.DeleteDnatEntry API asynchronously
func (client *Client) DeleteDnatEntryWithChan(request *DeleteDnatEntryRequest) (<-chan *DeleteDnatEntryResponse, <-chan error) {
	responseChan := make(chan *DeleteDnatEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDnatEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDnatEntryWithCallback invokes the smartag.DeleteDnatEntry API asynchronously
func (client *Client) DeleteDnatEntryWithCallback(request *DeleteDnatEntryRequest, callback func(response *DeleteDnatEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDnatEntryResponse
		var err error
		defer close(result)
		response, err = client.DeleteDnatEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDnatEntryRequest is the request struct for api DeleteDnatEntry
type DeleteDnatEntryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DnatEntryId          string           `position:"Query" name:"DnatEntryId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SagId                string           `position:"Query" name:"SagId"`
}

// DeleteDnatEntryResponse is the response struct for api DeleteDnatEntry
type DeleteDnatEntryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDnatEntryRequest creates a request to invoke DeleteDnatEntry API
func CreateDeleteDnatEntryRequest() (request *DeleteDnatEntryRequest) {
	request = &DeleteDnatEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DeleteDnatEntry", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDnatEntryResponse creates a response to parse from DeleteDnatEntry response
func CreateDeleteDnatEntryResponse() (response *DeleteDnatEntryResponse) {
	response = &DeleteDnatEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
