package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewaysForCms invokes the sgw.DescribeGatewaysForCms API synchronously
func (client *Client) DescribeGatewaysForCms(request *DescribeGatewaysForCmsRequest) (response *DescribeGatewaysForCmsResponse, err error) {
	response = CreateDescribeGatewaysForCmsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewaysForCmsWithChan invokes the sgw.DescribeGatewaysForCms API asynchronously
func (client *Client) DescribeGatewaysForCmsWithChan(request *DescribeGatewaysForCmsRequest) (<-chan *DescribeGatewaysForCmsResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewaysForCmsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewaysForCms(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewaysForCmsWithCallback invokes the sgw.DescribeGatewaysForCms API asynchronously
func (client *Client) DescribeGatewaysForCmsWithCallback(request *DescribeGatewaysForCmsRequest, callback func(response *DescribeGatewaysForCmsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewaysForCmsResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewaysForCms(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewaysForCmsRequest is the request struct for api DescribeGatewaysForCms
type DescribeGatewaysForCmsRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	GatewayRegionId string           `position:"Query" name:"GatewayRegionId"`
	SecurityToken   string           `position:"Query" name:"SecurityToken"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeGatewaysForCmsResponse is the response struct for api DescribeGatewaysForCms
type DescribeGatewaysForCmsResponse struct {
	*responses.BaseResponse
	RequestId  string                           `json:"RequestId" xml:"RequestId"`
	Success    bool                             `json:"Success" xml:"Success"`
	Code       string                           `json:"Code" xml:"Code"`
	Message    string                           `json:"Message" xml:"Message"`
	TotalCount int                              `json:"TotalCount" xml:"TotalCount"`
	PageNumber int                              `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                              `json:"PageSize" xml:"PageSize"`
	Gateways   GatewaysInDescribeGatewaysForCms `json:"Gateways" xml:"Gateways"`
}

// CreateDescribeGatewaysForCmsRequest creates a request to invoke DescribeGatewaysForCms API
func CreateDescribeGatewaysForCmsRequest() (request *DescribeGatewaysForCmsRequest) {
	request = &DescribeGatewaysForCmsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewaysForCms", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewaysForCmsResponse creates a response to parse from DescribeGatewaysForCms response
func CreateDescribeGatewaysForCmsResponse() (response *DescribeGatewaysForCmsResponse) {
	response = &DescribeGatewaysForCmsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
