package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAlarmEvent invokes the schedulerx3.ListAlarmEvent API synchronously
func (client *Client) ListAlarmEvent(request *ListAlarmEventRequest) (response *ListAlarmEventResponse, err error) {
	response = CreateListAlarmEventResponse()
	err = client.DoAction(request, response)
	return
}

// ListAlarmEventWithChan invokes the schedulerx3.ListAlarmEvent API asynchronously
func (client *Client) ListAlarmEventWithChan(request *ListAlarmEventRequest) (<-chan *ListAlarmEventResponse, <-chan error) {
	responseChan := make(chan *ListAlarmEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAlarmEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAlarmEventWithCallback invokes the schedulerx3.ListAlarmEvent API asynchronously
func (client *Client) ListAlarmEventWithCallback(request *ListAlarmEventRequest, callback func(response *ListAlarmEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAlarmEventResponse
		var err error
		defer close(result)
		response, err = client.ListAlarmEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAlarmEventRequest is the request struct for api ListAlarmEvent
type ListAlarmEventRequest struct {
	*requests.RpcRequest
	MseSessionId string           `position:"Query" name:"MseSessionId"`
	StartTime    requests.Integer `position:"Query" name:"StartTime"`
	PageNum      string           `position:"Query" name:"PageNum"`
	AlarmChannel string           `position:"Query" name:"AlarmChannel"`
	AppName      string           `position:"Query" name:"AppName"`
	PageSize     string           `position:"Query" name:"PageSize"`
	JobName      string           `position:"Query" name:"JobName"`
	AlarmType    string           `position:"Query" name:"AlarmType"`
	EndTime      requests.Integer `position:"Query" name:"EndTime"`
	ClusterId    string           `position:"Query" name:"ClusterId"`
	Reverse      requests.Boolean `position:"Query" name:"Reverse"`
	AlarmStatus  string           `position:"Query" name:"AlarmStatus"`
}

// ListAlarmEventResponse is the response struct for api ListAlarmEvent
type ListAlarmEventResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListAlarmEventRequest creates a request to invoke ListAlarmEvent API
func CreateListAlarmEventRequest() (request *ListAlarmEventRequest) {
	request = &ListAlarmEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "ListAlarmEvent", "", "")
	request.Method = requests.GET
	return
}

// CreateListAlarmEventResponse creates a response to parse from ListAlarmEvent response
func CreateListAlarmEventResponse() (response *ListAlarmEventResponse) {
	response = &ListAlarmEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
