package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVpcHoneyPotCriteria invokes the sas.DescribeVpcHoneyPotCriteria API synchronously
func (client *Client) DescribeVpcHoneyPotCriteria(request *DescribeVpcHoneyPotCriteriaRequest) (response *DescribeVpcHoneyPotCriteriaResponse, err error) {
	response = CreateDescribeVpcHoneyPotCriteriaResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVpcHoneyPotCriteriaWithChan invokes the sas.DescribeVpcHoneyPotCriteria API asynchronously
func (client *Client) DescribeVpcHoneyPotCriteriaWithChan(request *DescribeVpcHoneyPotCriteriaRequest) (<-chan *DescribeVpcHoneyPotCriteriaResponse, <-chan error) {
	responseChan := make(chan *DescribeVpcHoneyPotCriteriaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVpcHoneyPotCriteria(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVpcHoneyPotCriteriaWithCallback invokes the sas.DescribeVpcHoneyPotCriteria API asynchronously
func (client *Client) DescribeVpcHoneyPotCriteriaWithCallback(request *DescribeVpcHoneyPotCriteriaRequest, callback func(response *DescribeVpcHoneyPotCriteriaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVpcHoneyPotCriteriaResponse
		var err error
		defer close(result)
		response, err = client.DescribeVpcHoneyPotCriteria(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVpcHoneyPotCriteriaRequest is the request struct for api DescribeVpcHoneyPotCriteria
type DescribeVpcHoneyPotCriteriaRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeVpcHoneyPotCriteriaResponse is the response struct for api DescribeVpcHoneyPotCriteria
type DescribeVpcHoneyPotCriteriaResponse struct {
	*responses.BaseResponse
	RequestId    string     `json:"RequestId" xml:"RequestId"`
	CriteriaList []Criteria `json:"CriteriaList" xml:"CriteriaList"`
}

// CreateDescribeVpcHoneyPotCriteriaRequest creates a request to invoke DescribeVpcHoneyPotCriteria API
func CreateDescribeVpcHoneyPotCriteriaRequest() (request *DescribeVpcHoneyPotCriteriaRequest) {
	request = &DescribeVpcHoneyPotCriteriaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeVpcHoneyPotCriteria", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeVpcHoneyPotCriteriaResponse creates a response to parse from DescribeVpcHoneyPotCriteria response
func CreateDescribeVpcHoneyPotCriteriaResponse() (response *DescribeVpcHoneyPotCriteriaResponse) {
	response = &DescribeVpcHoneyPotCriteriaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
