package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecreateTable invokes the retailadvqa_public.RecreateTable API synchronously
func (client *Client) RecreateTable(request *RecreateTableRequest) (response *RecreateTableResponse, err error) {
	response = CreateRecreateTableResponse()
	err = client.DoAction(request, response)
	return
}

// RecreateTableWithChan invokes the retailadvqa_public.RecreateTable API asynchronously
func (client *Client) RecreateTableWithChan(request *RecreateTableRequest) (<-chan *RecreateTableResponse, <-chan error) {
	responseChan := make(chan *RecreateTableResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecreateTable(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecreateTableWithCallback invokes the retailadvqa_public.RecreateTable API asynchronously
func (client *Client) RecreateTableWithCallback(request *RecreateTableRequest, callback func(response *RecreateTableResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecreateTableResponse
		var err error
		defer close(result)
		response, err = client.RecreateTable(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecreateTableRequest is the request struct for api RecreateTable
type RecreateTableRequest struct {
	*requests.RpcRequest
	AccessId    string `position:"Body" name:"AccessId"`
	TableSchema string `position:"Body" name:"TableSchema"`
	TenantId    string `position:"Body" name:"TenantId"`
	TableName   string `position:"Body" name:"TableName"`
	OssPath     string `position:"Body" name:"OssPath"`
}

// RecreateTableResponse is the response struct for api RecreateTable
type RecreateTableResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateRecreateTableRequest creates a request to invoke RecreateTable API
func CreateRecreateTableRequest() (request *RecreateTableRequest) {
	request = &RecreateTableRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "RecreateTable", "", "")
	request.Method = requests.POST
	return
}

// CreateRecreateTableResponse creates a response to parse from RecreateTable response
func CreateRecreateTableResponse() (response *RecreateTableResponse) {
	response = &RecreateTableResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
