package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPermissionVersions invokes the resourcesharing.ListPermissionVersions API synchronously
func (client *Client) ListPermissionVersions(request *ListPermissionVersionsRequest) (response *ListPermissionVersionsResponse, err error) {
	response = CreateListPermissionVersionsResponse()
	err = client.DoAction(request, response)
	return
}

// ListPermissionVersionsWithChan invokes the resourcesharing.ListPermissionVersions API asynchronously
func (client *Client) ListPermissionVersionsWithChan(request *ListPermissionVersionsRequest) (<-chan *ListPermissionVersionsResponse, <-chan error) {
	responseChan := make(chan *ListPermissionVersionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPermissionVersions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPermissionVersionsWithCallback invokes the resourcesharing.ListPermissionVersions API asynchronously
func (client *Client) ListPermissionVersionsWithCallback(request *ListPermissionVersionsRequest, callback func(response *ListPermissionVersionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPermissionVersionsResponse
		var err error
		defer close(result)
		response, err = client.ListPermissionVersions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPermissionVersionsRequest is the request struct for api ListPermissionVersions
type ListPermissionVersionsRequest struct {
	*requests.RpcRequest
	PermissionName string           `position:"Query" name:"PermissionName"`
	NextToken      string           `position:"Query" name:"NextToken"`
	MaxResults     requests.Integer `position:"Query" name:"MaxResults"`
}

// ListPermissionVersionsResponse is the response struct for api ListPermissionVersions
type ListPermissionVersionsResponse struct {
	*responses.BaseResponse
	NextToken   string       `json:"NextToken" xml:"NextToken"`
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	Permissions []Permission `json:"Permissions" xml:"Permissions"`
}

// CreateListPermissionVersionsRequest creates a request to invoke ListPermissionVersions API
func CreateListPermissionVersionsRequest() (request *ListPermissionVersionsRequest) {
	request = &ListPermissionVersionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "ListPermissionVersions", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPermissionVersionsResponse creates a response to parse from ListPermissionVersions response
func CreateListPermissionVersionsResponse() (response *ListPermissionVersionsResponse) {
	response = &ListPermissionVersionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
