package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMultiAccountResourceCenterServiceStatus invokes the resourcecenter.GetMultiAccountResourceCenterServiceStatus API synchronously
func (client *Client) GetMultiAccountResourceCenterServiceStatus(request *GetMultiAccountResourceCenterServiceStatusRequest) (response *GetMultiAccountResourceCenterServiceStatusResponse, err error) {
	response = CreateGetMultiAccountResourceCenterServiceStatusResponse()
	err = client.DoAction(request, response)
	return
}

// GetMultiAccountResourceCenterServiceStatusWithChan invokes the resourcecenter.GetMultiAccountResourceCenterServiceStatus API asynchronously
func (client *Client) GetMultiAccountResourceCenterServiceStatusWithChan(request *GetMultiAccountResourceCenterServiceStatusRequest) (<-chan *GetMultiAccountResourceCenterServiceStatusResponse, <-chan error) {
	responseChan := make(chan *GetMultiAccountResourceCenterServiceStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMultiAccountResourceCenterServiceStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMultiAccountResourceCenterServiceStatusWithCallback invokes the resourcecenter.GetMultiAccountResourceCenterServiceStatus API asynchronously
func (client *Client) GetMultiAccountResourceCenterServiceStatusWithCallback(request *GetMultiAccountResourceCenterServiceStatusRequest, callback func(response *GetMultiAccountResourceCenterServiceStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMultiAccountResourceCenterServiceStatusResponse
		var err error
		defer close(result)
		response, err = client.GetMultiAccountResourceCenterServiceStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMultiAccountResourceCenterServiceStatusRequest is the request struct for api GetMultiAccountResourceCenterServiceStatus
type GetMultiAccountResourceCenterServiceStatusRequest struct {
	*requests.RpcRequest
}

// GetMultiAccountResourceCenterServiceStatusResponse is the response struct for api GetMultiAccountResourceCenterServiceStatus
type GetMultiAccountResourceCenterServiceStatusResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ServiceStatus string `json:"ServiceStatus" xml:"ServiceStatus"`
	InitialStatus string `json:"InitialStatus" xml:"InitialStatus"`
}

// CreateGetMultiAccountResourceCenterServiceStatusRequest creates a request to invoke GetMultiAccountResourceCenterServiceStatus API
func CreateGetMultiAccountResourceCenterServiceStatusRequest() (request *GetMultiAccountResourceCenterServiceStatusRequest) {
	request = &GetMultiAccountResourceCenterServiceStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "GetMultiAccountResourceCenterServiceStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMultiAccountResourceCenterServiceStatusResponse creates a response to parse from GetMultiAccountResourceCenterServiceStatus response
func CreateGetMultiAccountResourceCenterServiceStatusResponse() (response *GetMultiAccountResourceCenterServiceStatusResponse) {
	response = &GetMultiAccountResourceCenterServiceStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
