package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetExampleQuery invokes the resourcecenter.GetExampleQuery API synchronously
func (client *Client) GetExampleQuery(request *GetExampleQueryRequest) (response *GetExampleQueryResponse, err error) {
	response = CreateGetExampleQueryResponse()
	err = client.DoAction(request, response)
	return
}

// GetExampleQueryWithChan invokes the resourcecenter.GetExampleQuery API asynchronously
func (client *Client) GetExampleQueryWithChan(request *GetExampleQueryRequest) (<-chan *GetExampleQueryResponse, <-chan error) {
	responseChan := make(chan *GetExampleQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetExampleQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetExampleQueryWithCallback invokes the resourcecenter.GetExampleQuery API asynchronously
func (client *Client) GetExampleQueryWithCallback(request *GetExampleQueryRequest, callback func(response *GetExampleQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetExampleQueryResponse
		var err error
		defer close(result)
		response, err = client.GetExampleQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetExampleQueryRequest is the request struct for api GetExampleQuery
type GetExampleQueryRequest struct {
	*requests.RpcRequest
	QueryId string `position:"Query" name:"QueryId"`
}

// GetExampleQueryResponse is the response struct for api GetExampleQuery
type GetExampleQueryResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	ExampleQuery ExampleQuery `json:"ExampleQuery" xml:"ExampleQuery"`
}

// CreateGetExampleQueryRequest creates a request to invoke GetExampleQuery API
func CreateGetExampleQueryRequest() (request *GetExampleQueryRequest) {
	request = &GetExampleQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "GetExampleQuery", "", "")
	request.Method = requests.POST
	return
}

// CreateGetExampleQueryResponse creates a response to parse from GetExampleQuery response
func CreateGetExampleQueryResponse() (response *GetExampleQueryResponse) {
	response = &GetExampleQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
