package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBInstanceEndpointAddress invokes the rds.ModifyDBInstanceEndpointAddress API synchronously
func (client *Client) ModifyDBInstanceEndpointAddress(request *ModifyDBInstanceEndpointAddressRequest) (response *ModifyDBInstanceEndpointAddressResponse, err error) {
	response = CreateModifyDBInstanceEndpointAddressResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBInstanceEndpointAddressWithChan invokes the rds.ModifyDBInstanceEndpointAddress API asynchronously
func (client *Client) ModifyDBInstanceEndpointAddressWithChan(request *ModifyDBInstanceEndpointAddressRequest) (<-chan *ModifyDBInstanceEndpointAddressResponse, <-chan error) {
	responseChan := make(chan *ModifyDBInstanceEndpointAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBInstanceEndpointAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBInstanceEndpointAddressWithCallback invokes the rds.ModifyDBInstanceEndpointAddress API asynchronously
func (client *Client) ModifyDBInstanceEndpointAddressWithCallback(request *ModifyDBInstanceEndpointAddressRequest, callback func(response *ModifyDBInstanceEndpointAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBInstanceEndpointAddressResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBInstanceEndpointAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBInstanceEndpointAddressRequest is the request struct for api ModifyDBInstanceEndpointAddress
type ModifyDBInstanceEndpointAddressRequest struct {
	*requests.RpcRequest
	ConnectionStringPrefix string           `position:"Query" name:"ConnectionStringPrefix"`
	ResourceOwnerId        requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken            string           `position:"Query" name:"ClientToken"`
	ConnectionString       string           `position:"Query" name:"ConnectionString"`
	DBInstanceId           string           `position:"Query" name:"DBInstanceId"`
	VSwitchId              string           `position:"Query" name:"VSwitchId"`
	PrivateIpAddress       string           `position:"Query" name:"PrivateIpAddress"`
	DBInstanceEndpointId   string           `position:"Query" name:"DBInstanceEndpointId"`
	Port                   string           `position:"Query" name:"Port"`
	VpcId                  string           `position:"Query" name:"VpcId"`
}

// ModifyDBInstanceEndpointAddressResponse is the response struct for api ModifyDBInstanceEndpointAddress
type ModifyDBInstanceEndpointAddressResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateModifyDBInstanceEndpointAddressRequest creates a request to invoke ModifyDBInstanceEndpointAddress API
func CreateModifyDBInstanceEndpointAddressRequest() (request *ModifyDBInstanceEndpointAddressRequest) {
	request = &ModifyDBInstanceEndpointAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyDBInstanceEndpointAddress", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBInstanceEndpointAddressResponse creates a response to parse from ModifyDBInstanceEndpointAddress response
func CreateModifyDBInstanceEndpointAddressResponse() (response *ModifyDBInstanceEndpointAddressResponse) {
	response = &ModifyDBInstanceEndpointAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
