package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTaskExportTask invokes the outboundbot.CreateTaskExportTask API synchronously
func (client *Client) CreateTaskExportTask(request *CreateTaskExportTaskRequest) (response *CreateTaskExportTaskResponse, err error) {
	response = CreateCreateTaskExportTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTaskExportTaskWithChan invokes the outboundbot.CreateTaskExportTask API asynchronously
func (client *Client) CreateTaskExportTaskWithChan(request *CreateTaskExportTaskRequest) (<-chan *CreateTaskExportTaskResponse, <-chan error) {
	responseChan := make(chan *CreateTaskExportTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTaskExportTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTaskExportTaskWithCallback invokes the outboundbot.CreateTaskExportTask API asynchronously
func (client *Client) CreateTaskExportTaskWithCallback(request *CreateTaskExportTaskRequest, callback func(response *CreateTaskExportTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTaskExportTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateTaskExportTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTaskExportTaskRequest is the request struct for api CreateTaskExportTask
type CreateTaskExportTaskRequest struct {
	*requests.RpcRequest
	HasAnswered          requests.Boolean `position:"Query" name:"HasAnswered"`
	ActualTimeLte        requests.Integer `position:"Query" name:"ActualTimeLte"`
	OtherId              string           `position:"Query" name:"OtherId"`
	TaskCreateTimeLte    requests.Integer `position:"Query" name:"TaskCreateTimeLte"`
	JobId                string           `position:"Query" name:"JobId"`
	TaskCreateTimeGte    requests.Integer `position:"Query" name:"TaskCreateTimeGte"`
	CalledNumber         string           `position:"Query" name:"CalledNumber"`
	UserIdMatch          string           `position:"Query" name:"UserIdMatch"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ScriptNameQuery      string           `position:"Query" name:"ScriptNameQuery"`
	PageIndex            requests.Integer `position:"Query" name:"PageIndex"`
	SortOrder            string           `position:"Query" name:"SortOrder"`
	TaskStatusStringList string           `position:"Query" name:"TaskStatusStringList"`
	JobGroupNameQuery    string           `position:"Query" name:"JobGroupNameQuery"`
	TaskId               string           `position:"Query" name:"TaskId"`
	HasHangUpByRejection requests.Boolean `position:"Query" name:"HasHangUpByRejection"`
	HasReachedEndOfFlow  requests.Boolean `position:"Query" name:"HasReachedEndOfFlow"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	RecordingDurationGte requests.Integer `position:"Query" name:"RecordingDurationGte"`
	CallDurationLte      requests.Integer `position:"Query" name:"CallDurationLte"`
	JobGroupId           string           `position:"Query" name:"JobGroupId"`
	SortBy               string           `position:"Query" name:"SortBy"`
	JobStatusStringList  string           `position:"Query" name:"JobStatusStringList"`
	ActualTimeGte        requests.Integer `position:"Query" name:"ActualTimeGte"`
	CallDurationGte      requests.Integer `position:"Query" name:"CallDurationGte"`
	RecordingDurationLte requests.Integer `position:"Query" name:"RecordingDurationLte"`
}

// CreateTaskExportTaskResponse is the response struct for api CreateTaskExportTask
type CreateTaskExportTaskResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	TaskId         string `json:"TaskId" xml:"TaskId"`
}

// CreateCreateTaskExportTaskRequest creates a request to invoke CreateTaskExportTask API
func CreateCreateTaskExportTaskRequest() (request *CreateTaskExportTaskRequest) {
	request = &CreateTaskExportTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "CreateTaskExportTask", "", "")
	request.Method = requests.GET
	return
}

// CreateCreateTaskExportTaskResponse creates a response to parse from CreateTaskExportTask response
func CreateCreateTaskExportTaskResponse() (response *CreateTaskExportTaskResponse) {
	response = &CreateTaskExportTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
