package openanalytics

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenProductAccount invokes the openanalytics.OpenProductAccount API synchronously
// api document: https://help.aliyun.com/api/openanalytics/openproductaccount.html
func (client *Client) OpenProductAccount(request *OpenProductAccountRequest) (response *OpenProductAccountResponse, err error) {
	response = CreateOpenProductAccountResponse()
	err = client.DoAction(request, response)
	return
}

// OpenProductAccountWithChan invokes the openanalytics.OpenProductAccount API asynchronously
// api document: https://help.aliyun.com/api/openanalytics/openproductaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OpenProductAccountWithChan(request *OpenProductAccountRequest) (<-chan *OpenProductAccountResponse, <-chan error) {
	responseChan := make(chan *OpenProductAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenProductAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenProductAccountWithCallback invokes the openanalytics.OpenProductAccount API asynchronously
// api document: https://help.aliyun.com/api/openanalytics/openproductaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) OpenProductAccountWithCallback(request *OpenProductAccountRequest, callback func(response *OpenProductAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenProductAccountResponse
		var err error
		defer close(result)
		response, err = client.OpenProductAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenProductAccountRequest is the request struct for api OpenProductAccount
type OpenProductAccountRequest struct {
	*requests.RpcRequest
	ProductCode      string `position:"Body" name:"ProductCode"`
	ProductAccessKey string `position:"Body" name:"ProductAccessKey"`
	TargetUid        string `position:"Body" name:"TargetUid"`
	TargetArnRole    string `position:"Body" name:"TargetArnRole"`
}

// OpenProductAccountResponse is the response struct for api OpenProductAccount
type OpenProductAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	RegionId  string `json:"RegionId" xml:"RegionId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateOpenProductAccountRequest creates a request to invoke OpenProductAccount API
func CreateOpenProductAccountRequest() (request *OpenProductAccountRequest) {
	request = &OpenProductAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics", "2018-03-01", "OpenProductAccount", "openanalytics", "openAPI")
	return
}

// CreateOpenProductAccountResponse creates a response to parse from OpenProductAccount response
func CreateOpenProductAccountResponse() (response *OpenProductAccountResponse) {
	response = &OpenProductAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
