package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddAccount invokes the openanalytics_open.AddAccount API synchronously
func (client *Client) AddAccount(request *AddAccountRequest) (response *AddAccountResponse, err error) {
	response = CreateAddAccountResponse()
	err = client.DoAction(request, response)
	return
}

// AddAccountWithChan invokes the openanalytics_open.AddAccount API asynchronously
func (client *Client) AddAccountWithChan(request *AddAccountRequest) (<-chan *AddAccountResponse, <-chan error) {
	responseChan := make(chan *AddAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddAccountWithCallback invokes the openanalytics_open.AddAccount API asynchronously
func (client *Client) AddAccountWithCallback(request *AddAccountRequest, callback func(response *AddAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddAccountResponse
		var err error
		defer close(result)
		response, err = client.AddAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddAccountRequest is the request struct for api AddAccount
type AddAccountRequest struct {
	*requests.RpcRequest
	RamUid            string           `position:"Body" name:"RamUid"`
	IsShort           requests.Boolean `position:"Body" name:"IsShort"`
	Remark            string           `position:"Body" name:"Remark"`
	Password          string           `position:"Body" name:"Password"`
	AccountName       string           `position:"Body" name:"AccountName"`
	EnableKMS         requests.Boolean `position:"Body" name:"EnableKMS"`
	UseRandomPassword requests.Boolean `position:"Body" name:"UseRandomPassword"`
}

// AddAccountResponse is the response struct for api AddAccount
type AddAccountResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	RegionId  string  `json:"RegionId" xml:"RegionId"`
	Account   Account `json:"Account" xml:"Account"`
}

// CreateAddAccountRequest creates a request to invoke AddAccount API
func CreateAddAccountRequest() (request *AddAccountRequest) {
	request = &AddAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2018-06-19", "AddAccount", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddAccountResponse creates a response to parse from AddAccount response
func CreateAddAccountResponse() (response *AddAccountResponse) {
	response = &AddAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
