package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsConsumerAccumulate invokes the ons.OnsConsumerAccumulate API synchronously
func (client *Client) OnsConsumerAccumulate(request *OnsConsumerAccumulateRequest) (response *OnsConsumerAccumulateResponse, err error) {
	response = CreateOnsConsumerAccumulateResponse()
	err = client.DoAction(request, response)
	return
}

// OnsConsumerAccumulateWithChan invokes the ons.OnsConsumerAccumulate API asynchronously
func (client *Client) OnsConsumerAccumulateWithChan(request *OnsConsumerAccumulateRequest) (<-chan *OnsConsumerAccumulateResponse, <-chan error) {
	responseChan := make(chan *OnsConsumerAccumulateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsConsumerAccumulate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsConsumerAccumulateWithCallback invokes the ons.OnsConsumerAccumulate API asynchronously
func (client *Client) OnsConsumerAccumulateWithCallback(request *OnsConsumerAccumulateRequest, callback func(response *OnsConsumerAccumulateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsConsumerAccumulateResponse
		var err error
		defer close(result)
		response, err = client.OnsConsumerAccumulate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsConsumerAccumulateRequest is the request struct for api OnsConsumerAccumulate
type OnsConsumerAccumulateRequest struct {
	*requests.RpcRequest
	GroupId    string           `position:"Query" name:"GroupId"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	Detail     requests.Boolean `position:"Query" name:"Detail"`
}

// OnsConsumerAccumulateResponse is the response struct for api OnsConsumerAccumulate
type OnsConsumerAccumulateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	HelpUrl   string `json:"HelpUrl" xml:"HelpUrl"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateOnsConsumerAccumulateRequest creates a request to invoke OnsConsumerAccumulate API
func CreateOnsConsumerAccumulateRequest() (request *OnsConsumerAccumulateRequest) {
	request = &OnsConsumerAccumulateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsConsumerAccumulate", "ons", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOnsConsumerAccumulateResponse creates a response to parse from OnsConsumerAccumulate response
func CreateOnsConsumerAccumulateResponse() (response *OnsConsumerAccumulateResponse) {
	response = &OnsConsumerAccumulateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
