package oms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutDomainPart invokes the oms.PutDomainPart API synchronously
func (client *Client) PutDomainPart(request *PutDomainPartRequest) (response *PutDomainPartResponse, err error) {
	response = CreatePutDomainPartResponse()
	err = client.DoAction(request, response)
	return
}

// PutDomainPartWithChan invokes the oms.PutDomainPart API asynchronously
func (client *Client) PutDomainPartWithChan(request *PutDomainPartRequest) (<-chan *PutDomainPartResponse, <-chan error) {
	responseChan := make(chan *PutDomainPartResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutDomainPart(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutDomainPartWithCallback invokes the oms.PutDomainPart API asynchronously
func (client *Client) PutDomainPartWithCallback(request *PutDomainPartRequest, callback func(response *PutDomainPartResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutDomainPartResponse
		var err error
		defer close(result)
		response, err = client.PutDomainPart(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutDomainPartRequest is the request struct for api PutDomainPart
type PutDomainPartRequest struct {
	*requests.RpcRequest
	DomainCode string           `position:"Query" name:"DomainCode"`
	Data       string           `position:"Query" name:"Data"`
	DataType   string           `position:"Query" name:"DataType"`
	Compressed requests.Boolean `position:"Query" name:"Compressed"`
}

// PutDomainPartResponse is the response struct for api PutDomainPart
type PutDomainPartResponse struct {
	*responses.BaseResponse
	DataType   string `json:"DataType" xml:"DataType"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainCode string `json:"DomainCode" xml:"DomainCode"`
}

// CreatePutDomainPartRequest creates a request to invoke PutDomainPart API
func CreatePutDomainPartRequest() (request *PutDomainPartRequest) {
	request = &PutDomainPartRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oms", "2016-06-15", "PutDomainPart", "", "")
	request.Method = requests.POST
	return
}

// CreatePutDomainPartResponse creates a response to parse from PutDomainPart response
func CreatePutDomainPartResponse() (response *PutDomainPartResponse) {
	response = &PutDomainPartResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
