package oms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFileConfig invokes the oms.GetFileConfig API synchronously
func (client *Client) GetFileConfig(request *GetFileConfigRequest) (response *GetFileConfigResponse, err error) {
	response = CreateGetFileConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetFileConfigWithChan invokes the oms.GetFileConfig API asynchronously
func (client *Client) GetFileConfigWithChan(request *GetFileConfigRequest) (<-chan *GetFileConfigResponse, <-chan error) {
	responseChan := make(chan *GetFileConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFileConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFileConfigWithCallback invokes the oms.GetFileConfig API asynchronously
func (client *Client) GetFileConfigWithCallback(request *GetFileConfigRequest, callback func(response *GetFileConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFileConfigResponse
		var err error
		defer close(result)
		response, err = client.GetFileConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFileConfigRequest is the request struct for api GetFileConfig
type GetFileConfigRequest struct {
	*requests.RpcRequest
	DimensionType string `position:"Query" name:"DimensionType"`
	DomainCode    string `position:"Query" name:"DomainCode"`
}

// GetFileConfigResponse is the response struct for api GetFileConfig
type GetFileConfigResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Data         string `json:"Data" xml:"Data"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateGetFileConfigRequest creates a request to invoke GetFileConfig API
func CreateGetFileConfigRequest() (request *GetFileConfigRequest) {
	request = &GetFileConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oms", "2016-06-15", "GetFileConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateGetFileConfigResponse creates a response to parse from GetFileConfig response
func CreateGetFileConfigResponse() (response *GetFileConfigResponse) {
	response = &GetFileConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
