package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyTagName invokes the oceanbasepro.ModifyTagName API synchronously
func (client *Client) ModifyTagName(request *ModifyTagNameRequest) (response *ModifyTagNameResponse, err error) {
	response = CreateModifyTagNameResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyTagNameWithChan invokes the oceanbasepro.ModifyTagName API asynchronously
func (client *Client) ModifyTagNameWithChan(request *ModifyTagNameRequest) (<-chan *ModifyTagNameResponse, <-chan error) {
	responseChan := make(chan *ModifyTagNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyTagName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyTagNameWithCallback invokes the oceanbasepro.ModifyTagName API asynchronously
func (client *Client) ModifyTagNameWithCallback(request *ModifyTagNameRequest, callback func(response *ModifyTagNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyTagNameResponse
		var err error
		defer close(result)
		response, err = client.ModifyTagName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyTagNameRequest is the request struct for api ModifyTagName
type ModifyTagNameRequest struct {
	*requests.RpcRequest
	NewKey string `position:"Body" name:"NewKey"`
	Key    string `position:"Body" name:"Key"`
}

// ModifyTagNameResponse is the response struct for api ModifyTagName
type ModifyTagNameResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyTagNameRequest creates a request to invoke ModifyTagName API
func CreateModifyTagNameRequest() (request *ModifyTagNameRequest) {
	request = &ModifyTagNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "ModifyTagName", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyTagNameResponse creates a response to parse from ModifyTagName response
func CreateModifyTagNameResponse() (response *ModifyTagNameResponse) {
	response = &ModifyTagNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
