package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSlowSQLHistoryList invokes the oceanbasepro.DescribeSlowSQLHistoryList API synchronously
func (client *Client) DescribeSlowSQLHistoryList(request *DescribeSlowSQLHistoryListRequest) (response *DescribeSlowSQLHistoryListResponse, err error) {
	response = CreateDescribeSlowSQLHistoryListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSlowSQLHistoryListWithChan invokes the oceanbasepro.DescribeSlowSQLHistoryList API asynchronously
func (client *Client) DescribeSlowSQLHistoryListWithChan(request *DescribeSlowSQLHistoryListRequest) (<-chan *DescribeSlowSQLHistoryListResponse, <-chan error) {
	responseChan := make(chan *DescribeSlowSQLHistoryListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSlowSQLHistoryList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSlowSQLHistoryListWithCallback invokes the oceanbasepro.DescribeSlowSQLHistoryList API asynchronously
func (client *Client) DescribeSlowSQLHistoryListWithCallback(request *DescribeSlowSQLHistoryListRequest, callback func(response *DescribeSlowSQLHistoryListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSlowSQLHistoryListResponse
		var err error
		defer close(result)
		response, err = client.DescribeSlowSQLHistoryList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSlowSQLHistoryListRequest is the request struct for api DescribeSlowSQLHistoryList
type DescribeSlowSQLHistoryListRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Body" name:"StartTime"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	TenantId   string           `position:"Body" name:"TenantId"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
	SQLId      string           `position:"Body" name:"SQLId"`
	EndTime    string           `position:"Body" name:"EndTime"`
}

// DescribeSlowSQLHistoryListResponse is the response struct for api DescribeSlowSQLHistoryList
type DescribeSlowSQLHistoryListResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	SlowSQLHistoryList SlowSQLHistoryList `json:"SlowSQLHistoryList" xml:"SlowSQLHistoryList"`
}

// CreateDescribeSlowSQLHistoryListRequest creates a request to invoke DescribeSlowSQLHistoryList API
func CreateDescribeSlowSQLHistoryListRequest() (request *DescribeSlowSQLHistoryListRequest) {
	request = &DescribeSlowSQLHistoryListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeSlowSQLHistoryList", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSlowSQLHistoryListResponse creates a response to parse from DescribeSlowSQLHistoryList response
func CreateDescribeSlowSQLHistoryListResponse() (response *DescribeSlowSQLHistoryListResponse) {
	response = &DescribeSlowSQLHistoryListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
