package nas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateProtocolService invokes the nas.CreateProtocolService API synchronously
func (client *Client) CreateProtocolService(request *CreateProtocolServiceRequest) (response *CreateProtocolServiceResponse, err error) {
	response = CreateCreateProtocolServiceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateProtocolServiceWithChan invokes the nas.CreateProtocolService API asynchronously
func (client *Client) CreateProtocolServiceWithChan(request *CreateProtocolServiceRequest) (<-chan *CreateProtocolServiceResponse, <-chan error) {
	responseChan := make(chan *CreateProtocolServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateProtocolService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateProtocolServiceWithCallback invokes the nas.CreateProtocolService API asynchronously
func (client *Client) CreateProtocolServiceWithCallback(request *CreateProtocolServiceRequest, callback func(response *CreateProtocolServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateProtocolServiceResponse
		var err error
		defer close(result)
		response, err = client.CreateProtocolService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateProtocolServiceRequest is the request struct for api CreateProtocolService
type CreateProtocolServiceRequest struct {
	*requests.RpcRequest
	ClientToken                string           `position:"Query" name:"ClientToken"`
	Description                string           `position:"Query" name:"Description"`
	MountTargetDescription     string           `position:"Query" name:"MountTargetDescription"`
	MountTargetAccessGroupName string           `position:"Query" name:"MountTargetAccessGroupName"`
	MountTargetVSwitchId       string           `position:"Query" name:"MountTargetVSwitchId"`
	Throughput                 requests.Integer `position:"Query" name:"Throughput"`
	FileSystemId               string           `position:"Query" name:"FileSystemId"`
	DryRun                     requests.Boolean `position:"Query" name:"DryRun"`
	MountTargetFsetId          string           `position:"Query" name:"MountTargetFsetId"`
	VSwitchId                  string           `position:"Query" name:"VSwitchId"`
	MountTargetVpcId           string           `position:"Query" name:"MountTargetVpcId"`
	MountTargetPath            string           `position:"Query" name:"MountTargetPath"`
	ProtocolSpec               string           `position:"Query" name:"ProtocolSpec"`
	VpcId                      string           `position:"Query" name:"VpcId"`
	ProtocolType               string           `position:"Query" name:"ProtocolType"`
}

// CreateProtocolServiceResponse is the response struct for api CreateProtocolService
type CreateProtocolServiceResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	ProtocolServiceId string `json:"ProtocolServiceId" xml:"ProtocolServiceId"`
}

// CreateCreateProtocolServiceRequest creates a request to invoke CreateProtocolService API
func CreateCreateProtocolServiceRequest() (request *CreateProtocolServiceRequest) {
	request = &CreateProtocolServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("NAS", "2017-06-26", "CreateProtocolService", "nas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateProtocolServiceResponse creates a response to parse from CreateProtocolService response
func CreateCreateProtocolServiceResponse() (response *CreateProtocolServiceResponse) {
	response = &CreateProtocolServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
