package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMonitor invokes the mse.QueryMonitor API synchronously
func (client *Client) QueryMonitor(request *QueryMonitorRequest) (response *QueryMonitorResponse, err error) {
	response = CreateQueryMonitorResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMonitorWithChan invokes the mse.QueryMonitor API asynchronously
func (client *Client) QueryMonitorWithChan(request *QueryMonitorRequest) (<-chan *QueryMonitorResponse, <-chan error) {
	responseChan := make(chan *QueryMonitorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMonitor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMonitorWithCallback invokes the mse.QueryMonitor API asynchronously
func (client *Client) QueryMonitorWithCallback(request *QueryMonitorRequest, callback func(response *QueryMonitorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMonitorResponse
		var err error
		defer close(result)
		response, err = client.QueryMonitor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMonitorRequest is the request struct for api QueryMonitor
type QueryMonitorRequest struct {
	*requests.RpcRequest
	MseSessionId   string           `position:"Query" name:"MseSessionId"`
	StartTime      requests.Integer `position:"Query" name:"StartTime"`
	RequestPars    string           `position:"Query" name:"RequestPars"`
	MonitorType    string           `position:"Query" name:"MonitorType"`
	EndTime        requests.Integer `position:"Query" name:"EndTime"`
	ClusterId      string           `position:"Query" name:"ClusterId"`
	InstanceId     string           `position:"Query" name:"InstanceId"`
	AcceptLanguage string           `position:"Query" name:"AcceptLanguage"`
	Step           requests.Integer `position:"Query" name:"Step"`
}

// QueryMonitorResponse is the response struct for api QueryMonitor
type QueryMonitorResponse struct {
	*responses.BaseResponse
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	ErrorCode string     `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryMonitorRequest creates a request to invoke QueryMonitor API
func CreateQueryMonitorRequest() (request *QueryMonitorRequest) {
	request = &QueryMonitorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "QueryMonitor", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryMonitorResponse creates a response to parse from QueryMonitor response
func CreateQueryMonitorResponse() (response *QueryMonitorResponse) {
	response = &QueryMonitorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
