package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddMigrationTask invokes the mse.AddMigrationTask API synchronously
func (client *Client) AddMigrationTask(request *AddMigrationTaskRequest) (response *AddMigrationTaskResponse, err error) {
	response = CreateAddMigrationTaskResponse()
	err = client.DoAction(request, response)
	return
}

// AddMigrationTaskWithChan invokes the mse.AddMigrationTask API asynchronously
func (client *Client) AddMigrationTaskWithChan(request *AddMigrationTaskRequest) (<-chan *AddMigrationTaskResponse, <-chan error) {
	responseChan := make(chan *AddMigrationTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddMigrationTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddMigrationTaskWithCallback invokes the mse.AddMigrationTask API asynchronously
func (client *Client) AddMigrationTaskWithCallback(request *AddMigrationTaskRequest, callback func(response *AddMigrationTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddMigrationTaskResponse
		var err error
		defer close(result)
		response, err = client.AddMigrationTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddMigrationTaskRequest is the request struct for api AddMigrationTask
type AddMigrationTaskRequest struct {
	*requests.RpcRequest
	MseSessionId            string `position:"Query" name:"MseSessionId"`
	SyncType                string `position:"Query" name:"SyncType"`
	RequestPars             string `position:"Query" name:"RequestPars"`
	Id                      string `position:"Query" name:"Id"`
	OriginInstanceName      string `position:"Query" name:"OriginInstanceName"`
	ProjectDesc             string `position:"Query" name:"ProjectDesc"`
	ClusterType             string `position:"Query" name:"ClusterType"`
	TargetClusterName       string `position:"Query" name:"TargetClusterName"`
	TargetClusterUrl        string `position:"Query" name:"TargetClusterUrl"`
	OriginInstanceAddress   string `position:"Query" name:"OriginInstanceAddress"`
	OriginInstanceNamespace string `position:"Query" name:"OriginInstanceNamespace"`
	TargetInstanceId        string `position:"Query" name:"TargetInstanceId"`
	AcceptLanguage          string `position:"Query" name:"AcceptLanguage"`
}

// AddMigrationTaskResponse is the response struct for api AddMigrationTask
type AddMigrationTaskResponse struct {
	*responses.BaseResponse
	HttpCode  string `json:"HttpCode" xml:"HttpCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAddMigrationTaskRequest creates a request to invoke AddMigrationTask API
func CreateAddMigrationTaskRequest() (request *AddMigrationTaskRequest) {
	request = &AddMigrationTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "AddMigrationTask", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddMigrationTaskResponse creates a response to parse from AddMigrationTask response
func CreateAddMigrationTaskResponse() (response *AddMigrationTaskResponse) {
	response = &AddMigrationTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
