package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMessageGroupUser invokes the live.ListMessageGroupUser API synchronously
func (client *Client) ListMessageGroupUser(request *ListMessageGroupUserRequest) (response *ListMessageGroupUserResponse, err error) {
	response = CreateListMessageGroupUserResponse()
	err = client.DoAction(request, response)
	return
}

// ListMessageGroupUserWithChan invokes the live.ListMessageGroupUser API asynchronously
func (client *Client) ListMessageGroupUserWithChan(request *ListMessageGroupUserRequest) (<-chan *ListMessageGroupUserResponse, <-chan error) {
	responseChan := make(chan *ListMessageGroupUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMessageGroupUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMessageGroupUserWithCallback invokes the live.ListMessageGroupUser API asynchronously
func (client *Client) ListMessageGroupUserWithCallback(request *ListMessageGroupUserRequest, callback func(response *ListMessageGroupUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMessageGroupUserResponse
		var err error
		defer close(result)
		response, err = client.ListMessageGroupUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMessageGroupUserRequest is the request struct for api ListMessageGroupUser
type ListMessageGroupUserRequest struct {
	*requests.RpcRequest
	SortType requests.Integer `position:"Body" name:"SortType"`
	PageNum  requests.Integer `position:"Body" name:"PageNum"`
	PageSize requests.Integer `position:"Body" name:"PageSize"`
	GroupId  string           `position:"Body" name:"GroupId"`
	AppId    string           `position:"Body" name:"AppId"`
}

// ListMessageGroupUserResponse is the response struct for api ListMessageGroupUser
type ListMessageGroupUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateListMessageGroupUserRequest creates a request to invoke ListMessageGroupUser API
func CreateListMessageGroupUserRequest() (request *ListMessageGroupUserRequest) {
	request = &ListMessageGroupUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListMessageGroupUser", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListMessageGroupUserResponse creates a response to parse from ListMessageGroupUser response
func CreateListMessageGroupUserResponse() (response *ListMessageGroupUserResponse) {
	response = &ListMessageGroupUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
