package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLivePrivateLine invokes the live.DeleteLivePrivateLine API synchronously
func (client *Client) DeleteLivePrivateLine(request *DeleteLivePrivateLineRequest) (response *DeleteLivePrivateLineResponse, err error) {
	response = CreateDeleteLivePrivateLineResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLivePrivateLineWithChan invokes the live.DeleteLivePrivateLine API asynchronously
func (client *Client) DeleteLivePrivateLineWithChan(request *DeleteLivePrivateLineRequest) (<-chan *DeleteLivePrivateLineResponse, <-chan error) {
	responseChan := make(chan *DeleteLivePrivateLineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLivePrivateLine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLivePrivateLineWithCallback invokes the live.DeleteLivePrivateLine API asynchronously
func (client *Client) DeleteLivePrivateLineWithCallback(request *DeleteLivePrivateLineRequest, callback func(response *DeleteLivePrivateLineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLivePrivateLineResponse
		var err error
		defer close(result)
		response, err = client.DeleteLivePrivateLine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLivePrivateLineRequest is the request struct for api DeleteLivePrivateLine
type DeleteLivePrivateLineRequest struct {
	*requests.RpcRequest
	AppName          string           `position:"Query" name:"AppName"`
	StreamName       string           `position:"Query" name:"StreamName"`
	DomainName       string           `position:"Query" name:"DomainName"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	AccelerationType string           `position:"Query" name:"AccelerationType"`
}

// DeleteLivePrivateLineResponse is the response struct for api DeleteLivePrivateLine
type DeleteLivePrivateLineResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLivePrivateLineRequest creates a request to invoke DeleteLivePrivateLine API
func CreateDeleteLivePrivateLineRequest() (request *DeleteLivePrivateLineRequest) {
	request = &DeleteLivePrivateLineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLivePrivateLine", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLivePrivateLineResponse creates a response to parse from DeleteLivePrivateLine response
func CreateDeleteLivePrivateLineResponse() (response *DeleteLivePrivateLineResponse) {
	response = &DeleteLivePrivateLineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
