package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNetworkAcls invokes the ens.DescribeNetworkAcls API synchronously
func (client *Client) DescribeNetworkAcls(request *DescribeNetworkAclsRequest) (response *DescribeNetworkAclsResponse, err error) {
	response = CreateDescribeNetworkAclsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNetworkAclsWithChan invokes the ens.DescribeNetworkAcls API asynchronously
func (client *Client) DescribeNetworkAclsWithChan(request *DescribeNetworkAclsRequest) (<-chan *DescribeNetworkAclsResponse, <-chan error) {
	responseChan := make(chan *DescribeNetworkAclsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNetworkAcls(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNetworkAclsWithCallback invokes the ens.DescribeNetworkAcls API asynchronously
func (client *Client) DescribeNetworkAclsWithCallback(request *DescribeNetworkAclsRequest, callback func(response *DescribeNetworkAclsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNetworkAclsResponse
		var err error
		defer close(result)
		response, err = client.DescribeNetworkAcls(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNetworkAclsRequest is the request struct for api DescribeNetworkAcls
type DescribeNetworkAclsRequest struct {
	*requests.RpcRequest
	PageNumber     string `position:"Query" name:"PageNumber"`
	PageSize       string `position:"Query" name:"PageSize"`
	NetworkAclId   string `position:"Query" name:"NetworkAclId"`
	ResourceId     string `position:"Query" name:"ResourceId"`
	NetworkAclName string `position:"Query" name:"NetworkAclName"`
}

// DescribeNetworkAclsResponse is the response struct for api DescribeNetworkAcls
type DescribeNetworkAclsResponse struct {
	*responses.BaseResponse
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	TotalCount  string       `json:"TotalCount" xml:"TotalCount"`
	PageSize    string       `json:"PageSize" xml:"PageSize"`
	PageNumber  string       `json:"PageNumber" xml:"PageNumber"`
	NetworkAcls []NetworkAcl `json:"NetworkAcls" xml:"NetworkAcls"`
}

// CreateDescribeNetworkAclsRequest creates a request to invoke DescribeNetworkAcls API
func CreateDescribeNetworkAclsRequest() (request *DescribeNetworkAclsRequest) {
	request = &DescribeNetworkAclsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeNetworkAcls", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeNetworkAclsResponse creates a response to parse from DescribeNetworkAcls response
func CreateDescribeNetworkAclsResponse() (response *DescribeNetworkAclsResponse) {
	response = &DescribeNetworkAclsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
