package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveScalingConfigItemV2 invokes the emr.RemoveScalingConfigItemV2 API synchronously
func (client *Client) RemoveScalingConfigItemV2(request *RemoveScalingConfigItemV2Request) (response *RemoveScalingConfigItemV2Response, err error) {
	response = CreateRemoveScalingConfigItemV2Response()
	err = client.DoAction(request, response)
	return
}

// RemoveScalingConfigItemV2WithChan invokes the emr.RemoveScalingConfigItemV2 API asynchronously
func (client *Client) RemoveScalingConfigItemV2WithChan(request *RemoveScalingConfigItemV2Request) (<-chan *RemoveScalingConfigItemV2Response, <-chan error) {
	responseChan := make(chan *RemoveScalingConfigItemV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveScalingConfigItemV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveScalingConfigItemV2WithCallback invokes the emr.RemoveScalingConfigItemV2 API asynchronously
func (client *Client) RemoveScalingConfigItemV2WithCallback(request *RemoveScalingConfigItemV2Request, callback func(response *RemoveScalingConfigItemV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveScalingConfigItemV2Response
		var err error
		defer close(result)
		response, err = client.RemoveScalingConfigItemV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveScalingConfigItemV2Request is the request struct for api RemoveScalingConfigItemV2
type RemoveScalingConfigItemV2Request struct {
	*requests.RpcRequest
	ConfigItemType    string           `position:"Query" name:"ConfigItemType"`
	ConfigItemBizId   string           `position:"Query" name:"ConfigItemBizId"`
	ResourceOwnerId   requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ScalingGroupBizId string           `position:"Query" name:"ScalingGroupBizId"`
	ResourceGroupId   string           `position:"Query" name:"ResourceGroupId"`
}

// RemoveScalingConfigItemV2Response is the response struct for api RemoveScalingConfigItemV2
type RemoveScalingConfigItemV2Response struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateRemoveScalingConfigItemV2Request creates a request to invoke RemoveScalingConfigItemV2 API
func CreateRemoveScalingConfigItemV2Request() (request *RemoveScalingConfigItemV2Request) {
	request = &RemoveScalingConfigItemV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "RemoveScalingConfigItemV2", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveScalingConfigItemV2Response creates a response to parse from RemoveScalingConfigItemV2 response
func CreateRemoveScalingConfigItemV2Response() (response *RemoveScalingConfigItemV2Response) {
	response = &RemoveScalingConfigItemV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
