package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CloseDiagnosis invokes the elasticsearch.CloseDiagnosis API synchronously
func (client *Client) CloseDiagnosis(request *CloseDiagnosisRequest) (response *CloseDiagnosisResponse, err error) {
	response = CreateCloseDiagnosisResponse()
	err = client.DoAction(request, response)
	return
}

// CloseDiagnosisWithChan invokes the elasticsearch.CloseDiagnosis API asynchronously
func (client *Client) CloseDiagnosisWithChan(request *CloseDiagnosisRequest) (<-chan *CloseDiagnosisResponse, <-chan error) {
	responseChan := make(chan *CloseDiagnosisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CloseDiagnosis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CloseDiagnosisWithCallback invokes the elasticsearch.CloseDiagnosis API asynchronously
func (client *Client) CloseDiagnosisWithCallback(request *CloseDiagnosisRequest, callback func(response *CloseDiagnosisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CloseDiagnosisResponse
		var err error
		defer close(result)
		response, err = client.CloseDiagnosis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CloseDiagnosisRequest is the request struct for api CloseDiagnosis
type CloseDiagnosisRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"ClientToken"`
	Lang        string `position:"Query" name:"lang"`
}

// CloseDiagnosisResponse is the response struct for api CloseDiagnosis
type CloseDiagnosisResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCloseDiagnosisRequest creates a request to invoke CloseDiagnosis API
func CreateCloseDiagnosisRequest() (request *CloseDiagnosisRequest) {
	request = &CloseDiagnosisRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "CloseDiagnosis", "/openapi/diagnosis/instances/[InstanceId]/actions/close-diagnosis", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCloseDiagnosisResponse creates a response to parse from CloseDiagnosis response
func CreateCloseDiagnosisResponse() (response *CloseDiagnosisResponse) {
	response = &CloseDiagnosisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
