package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDesktopGroupSessions invokes the ecd.DescribeDesktopGroupSessions API synchronously
func (client *Client) DescribeDesktopGroupSessions(request *DescribeDesktopGroupSessionsRequest) (response *DescribeDesktopGroupSessionsResponse, err error) {
	response = CreateDescribeDesktopGroupSessionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDesktopGroupSessionsWithChan invokes the ecd.DescribeDesktopGroupSessions API asynchronously
func (client *Client) DescribeDesktopGroupSessionsWithChan(request *DescribeDesktopGroupSessionsRequest) (<-chan *DescribeDesktopGroupSessionsResponse, <-chan error) {
	responseChan := make(chan *DescribeDesktopGroupSessionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDesktopGroupSessions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDesktopGroupSessionsWithCallback invokes the ecd.DescribeDesktopGroupSessions API asynchronously
func (client *Client) DescribeDesktopGroupSessionsWithCallback(request *DescribeDesktopGroupSessionsRequest, callback func(response *DescribeDesktopGroupSessionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDesktopGroupSessionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDesktopGroupSessions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDesktopGroupSessionsRequest is the request struct for api DescribeDesktopGroupSessions
type DescribeDesktopGroupSessionsRequest struct {
	*requests.RpcRequest
	OwnType       requests.Integer `position:"Query" name:"OwnType"`
	EndTime       string           `position:"Query" name:"EndTime"`
	StartTime     string           `position:"Query" name:"StartTime"`
	SessionStatus string           `position:"Query" name:"SessionStatus"`
	NextToken     string           `position:"Query" name:"NextToken"`
	MaxResults    requests.Integer `position:"Query" name:"MaxResults"`
	EndUserId     string           `position:"Query" name:"EndUserId"`
}

// DescribeDesktopGroupSessionsResponse is the response struct for api DescribeDesktopGroupSessions
type DescribeDesktopGroupSessionsResponse struct {
	*responses.BaseResponse
	RequestId  string    `json:"RequestId" xml:"RequestId"`
	TotalCount int       `json:"TotalCount" xml:"TotalCount"`
	NextToken  string    `json:"NextToken" xml:"NextToken"`
	Sessions   []Session `json:"Sessions" xml:"Sessions"`
}

// CreateDescribeDesktopGroupSessionsRequest creates a request to invoke DescribeDesktopGroupSessions API
func CreateDescribeDesktopGroupSessionsRequest() (request *DescribeDesktopGroupSessionsRequest) {
	request = &DescribeDesktopGroupSessionsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeDesktopGroupSessions", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDesktopGroupSessionsResponse creates a response to parse from DescribeDesktopGroupSessions response
func CreateDescribeDesktopGroupSessionsResponse() (response *DescribeDesktopGroupSessionsResponse) {
	response = &DescribeDesktopGroupSessionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
