package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCloudDriveUsers invokes the ecd.CreateCloudDriveUsers API synchronously
func (client *Client) CreateCloudDriveUsers(request *CreateCloudDriveUsersRequest) (response *CreateCloudDriveUsersResponse, err error) {
	response = CreateCreateCloudDriveUsersResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCloudDriveUsersWithChan invokes the ecd.CreateCloudDriveUsers API asynchronously
func (client *Client) CreateCloudDriveUsersWithChan(request *CreateCloudDriveUsersRequest) (<-chan *CreateCloudDriveUsersResponse, <-chan error) {
	responseChan := make(chan *CreateCloudDriveUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCloudDriveUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCloudDriveUsersWithCallback invokes the ecd.CreateCloudDriveUsers API asynchronously
func (client *Client) CreateCloudDriveUsersWithCallback(request *CreateCloudDriveUsersRequest, callback func(response *CreateCloudDriveUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCloudDriveUsersResponse
		var err error
		defer close(result)
		response, err = client.CreateCloudDriveUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCloudDriveUsersRequest is the request struct for api CreateCloudDriveUsers
type CreateCloudDriveUsersRequest struct {
	*requests.RpcRequest
	CdsId       string           `position:"Query" name:"CdsId"`
	EndUserId   *[]string        `position:"Query" name:"EndUserId"  type:"Repeated"`
	UserMaxSize requests.Integer `position:"Query" name:"UserMaxSize"`
}

// CreateCloudDriveUsersResponse is the response struct for api CreateCloudDriveUsers
type CreateCloudDriveUsersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateCloudDriveUsersRequest creates a request to invoke CreateCloudDriveUsers API
func CreateCreateCloudDriveUsersRequest() (request *CreateCloudDriveUsersRequest) {
	request = &CreateCloudDriveUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "CreateCloudDriveUsers", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCloudDriveUsersResponse creates a response to parse from CreateCloudDriveUsers response
func CreateCreateCloudDriveUsersResponse() (response *CreateCloudDriveUsersResponse) {
	response = &CreateCloudDriveUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
