package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteStandardGroup invokes the dms_enterprise.DeleteStandardGroup API synchronously
func (client *Client) DeleteStandardGroup(request *DeleteStandardGroupRequest) (response *DeleteStandardGroupResponse, err error) {
	response = CreateDeleteStandardGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteStandardGroupWithChan invokes the dms_enterprise.DeleteStandardGroup API asynchronously
func (client *Client) DeleteStandardGroupWithChan(request *DeleteStandardGroupRequest) (<-chan *DeleteStandardGroupResponse, <-chan error) {
	responseChan := make(chan *DeleteStandardGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteStandardGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteStandardGroupWithCallback invokes the dms_enterprise.DeleteStandardGroup API asynchronously
func (client *Client) DeleteStandardGroupWithCallback(request *DeleteStandardGroupRequest, callback func(response *DeleteStandardGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteStandardGroupResponse
		var err error
		defer close(result)
		response, err = client.DeleteStandardGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteStandardGroupRequest is the request struct for api DeleteStandardGroup
type DeleteStandardGroupRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	GroupId requests.Integer `position:"Query" name:"GroupId"`
}

// DeleteStandardGroupResponse is the response struct for api DeleteStandardGroup
type DeleteStandardGroupResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateDeleteStandardGroupRequest creates a request to invoke DeleteStandardGroup API
func CreateDeleteStandardGroupRequest() (request *DeleteStandardGroupRequest) {
	request = &DeleteStandardGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "DeleteStandardGroup", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteStandardGroupResponse creates a response to parse from DeleteStandardGroup response
func CreateDeleteStandardGroupResponse() (response *DeleteStandardGroupResponse) {
	response = &DeleteStandardGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
